/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.rest.configuration.CorsRuleConfiguration;

public class CorsConfiguration
implements ConfigurationInfo {
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("cors-rules");
    private final List<CorsConfig> nettyCorsConfigs;
    private List<CorsRuleConfiguration> corsConfigurations;
    private List<ConfigurationInfo> elements = new ArrayList<ConfigurationInfo>();

    CorsConfiguration(List<CorsRuleConfiguration> corsConfigurations, List<CorsConfig> extraConfigs) {
        this.corsConfigurations = corsConfigurations;
        this.nettyCorsConfigs = corsConfigurations.stream().map(CorsRuleConfiguration::corsConfig).collect(Collectors.toList());
        this.nettyCorsConfigs.addAll(extraConfigs);
        this.elements.addAll(corsConfigurations);
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    List<CorsRuleConfiguration> corsRules() {
        return this.corsConfigurations;
    }

    List<CorsConfig> corsConfigs() {
        return this.nettyCorsConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorsConfiguration that = (CorsConfiguration)o;
        return this.corsConfigurations.equals(that.corsConfigurations);
    }

    public int hashCode() {
        return this.corsConfigurations.hashCode();
    }

    public String toString() {
        return "CorsRulesConfiguration{corsConfigurations=" + this.corsConfigurations + '}';
    }
}

