/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.CorsConfiguration;
import org.infinispan.rest.configuration.CorsRuleConfiguration;
import org.infinispan.rest.configuration.CorsRuleConfigurationBuilder;

public class CorsConfigurationBuilder
implements Builder<CorsConfiguration> {
    private List<CorsRuleConfigurationBuilder> corsRules = new ArrayList<CorsRuleConfigurationBuilder>();
    private List<CorsConfig> extraConfigs = new ArrayList<CorsConfig>();

    public CorsRuleConfigurationBuilder addNewRule() {
        CorsRuleConfigurationBuilder builder = new CorsRuleConfigurationBuilder();
        this.corsRules.add(builder);
        return builder;
    }

    CorsConfigurationBuilder corsAllowForLocalhost(Set<String> schemes, int[] ports) {
        for (String scheme : schemes) {
            for (int port : ports) {
                String localIpv4 = scheme + "://127.0.0.1:" + port;
                String localDomain = scheme + "://localhost:" + port;
                String localIpv6 = scheme + "://[::1]:" + port;
                this.addNewRule().allowOrigins(new String[]{localIpv4, localDomain, localIpv6}).allowCredentials(true).allowMethods(new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"}).allowHeaders(new String[]{HttpHeaderNames.CONTENT_TYPE.toString()});
            }
        }
        return this;
    }

    public CorsConfigurationBuilder add(List<CorsConfig> corsConfig) {
        this.extraConfigs = corsConfig;
        return this;
    }

    public CorsConfiguration create() {
        List<CorsRuleConfiguration> cors = this.corsRules.stream().distinct().map(CorsRuleConfigurationBuilder::create).collect(Collectors.toList());
        return new CorsConfiguration(cors, this.extraConfigs);
    }

    public CorsConfigurationBuilder read(CorsConfiguration template) {
        this.corsRules.clear();
        template.corsRules().forEach(r -> this.addNewRule().read((CorsRuleConfiguration)r));
        return this;
    }

    public void validate() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorsConfigurationBuilder that = (CorsConfigurationBuilder)o;
        if (!this.corsRules.equals(that.corsRules)) {
            return false;
        }
        return this.extraConfigs.equals(that.extraConfigs);
    }

    public int hashCode() {
        int result = this.corsRules.hashCode();
        result = 31 * result + this.extraConfigs.hashCode();
        return result;
    }
}

