/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.CacheManagerResource;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.stats.Stats;

public class CacheResourceV2
extends CacheResource {
    public CacheResourceV2(InvocationHelper invocationHelper) {
        super(invocationHelper);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}").withAction("config").handleWith(this::getCacheConfig).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("stats").handleWith(this::getCacheStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").handleWith(this::createCache).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}").handleWith(this::removeCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("clear").handleWith(this::clearEntireCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("size").handleWith(this::getSize).invocation().methods(Method.GET, Method.POST).path("/v2/caches/{cacheName}").withAction("search").handleWith(this.queryAction::search).create();
    }

    private CompletionStage<RestResponse> removeCache(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, request.getSubject());
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return CompletableFuture.supplyAsync(() -> {
            restCacheManager.getInstance().administration().removeCache(cacheName);
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletableFuture<RestResponse> createCache(RestRequest request) {
        MediaType sourceType;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        List<String> template = request.parameters().get("template");
        String cacheName = request.variables().get("cacheName");
        EmbeddedCacheManagerAdmin administration = this.invocationHelper.getRestCacheManager().getInstance().administration();
        if (template != null && !template.isEmpty()) {
            String templateName = template.iterator().next();
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, templateName);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        if (bytes == null || bytes.length == 0) {
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, (String)null);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        MediaType mediaType = sourceType = request.contentType() == null ? MediaType.APPLICATION_JSON : request.contentType();
        if (sourceType.match(MediaType.APPLICATION_JSON)) {
            this.invocationHelper.getJsonReader().readJson((ConfigurationBuilderInfo)cfgBuilder, StandardConversions.convertTextToObject((Object)bytes, (MediaType)sourceType));
        } else if (sourceType.match(MediaType.APPLICATION_XML)) {
            ConfigurationBuilderHolder builderHolder = this.invocationHelper.getParserRegistry().parse(new String(bytes, StandardCharsets.UTF_8));
            cfgBuilder = builderHolder.getCurrentConfigurationBuilder();
        } else {
            responseBuilder.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ConfigurationBuilder finalCfgBuilder = cfgBuilder;
        return CompletableFuture.supplyAsync(() -> {
            administration.createCache(cacheName, finalCfgBuilder.build());
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request.getSubject());
        Stats stats = cache.getAdvancedCache().getStats();
        try {
            byte[] statsResponse = this.invocationHelper.getMapper().writeValueAsBytes((Object)stats);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(statsResponse).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getCacheConfig(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        MediaType accept = CacheManagerResource.getAccept(request);
        responseBuilder.contentType(accept);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request.getSubject())) == null) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND.code()).build());
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        String entity = accept.getTypeSubtype().equals("application/xml") ? cacheConfiguration.toXMLString() : this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)cacheConfiguration);
        return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.OK).entity(entity).build());
    }

    private CompletionStage<RestResponse> getSize(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request.getSubject());
        return CompletableFuture.supplyAsync(() -> {
            try {
                int size = cache.size();
                responseBuilder.entity(this.invocationHelper.getMapper().writeValueAsBytes((Object)size));
            }
            catch (JsonProcessingException e) {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }
}

