/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheV2ResourceTest")
public class CacheV2ResourceTest
extends AbstractRestResourceTest {
    private static final String PERSISTENT_LOCATION = TestingUtil.tmpDirectory((String)CacheV2ResourceTest.class.getName());
    private static final String TMP_LOCATION = PERSISTENT_LOCATION + File.separator + "tmp";
    private static final String SHARED_LOCATION = PERSISTENT_LOCATION + File.separator + "shared";

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        cm.defineConfiguration("indexedCache", this.getIndexedPersistedCache().build());
    }

    private ConfigurationBuilder getIndexedPersistedCache() {
        ConfigurationBuilder builder = CacheV2ResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.indexing().index(Index.PRIMARY_OWNER).autoConfig(true).jmxStatistics().enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("store");
        return builder;
    }

    @AfterClass
    public void tearDown() {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(PERSISTENT_LOCATION + File.separator + id).temporaryLocation(TMP_LOCATION + File.separator + id).sharedPersistentLocation(SHARED_LOCATION + File.separator + id);
        return config;
    }

    @Test
    public void testCacheV2KeyOps() throws Exception {
        String urlWithoutCM = String.format("http://localhost:%d/rest/v2/caches/default", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("value")).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.POST).content((ContentProvider)new StringContentProvider("value")).send();
        ResponseAssertion.assertThat(response).isConflicted();
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.PUT).content((ContentProvider)new StringContentProvider("value-new")).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).hasReturnedText("value-new");
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.HEAD).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(urlWithoutCM + "/key").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testCacheV2LifeCycle() throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/caches/", this.restServer().getPort());
        String xml = Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        String json = Util.getResourceAsString((String)"cache.json", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ContentResponse response = this.client.newRequest(url + "cache1").header("Content-type", "application/xml").method(HttpMethod.POST).header("flags", "VOLATILE").content((ContentProvider)new StringContentProvider(xml)).send();
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache1", false);
        response = this.client.newRequest(url + "cache2").header("Content-type", "application/json").method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(json)).send();
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache2", true);
        String mediaList = "application/json,text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        response = this.client.newRequest(url + "cache1?action=config").method(HttpMethod.GET).header("Accept", mediaList).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).bodyNotEmpty();
        String cache1Cfg = response.getContentAsString();
        response = this.client.newRequest(url + "cache2?action=config").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).bodyNotEmpty();
        String cache2Cfg = response.getContentAsString();
        AssertJUnit.assertEquals((String)cache1Cfg, (String)cache2Cfg);
        response = this.client.newRequest(url + "cache1").method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(url + "cache1?action=stats").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    private void assertPersistence(String name, boolean persisted) {
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache configCache = cm.getCache("org.infinispan.CONFIG");
        AssertJUnit.assertEquals((boolean)persisted, (boolean)configCache.entrySet().stream().anyMatch((SerializablePredicate & Serializable)e -> ((ScopedState)e.getKey()).getName().equals(name) && !((CacheState)e.getValue()).getFlags().contains(CacheContainerAdmin.AdminFlag.VOLATILE)));
    }

    @Test
    public void testCacheV2Stats() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true } }";
        String cacheURL = String.format("http://localhost:%d/rest/v2/caches/statCache", this.restServer().getPort());
        String url = String.format(cacheURL, this.restServer().getPort());
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.POST).header(HttpHeader.CONTENT_TYPE, "application/json").content((ContentProvider)new StringContentProvider(cacheJson)).send();
        ResponseAssertion.assertThat(response).isOk();
        this.putStringValueInCache("statCache", "key1", "data");
        this.putStringValueInCache("statCache", "key2", "data");
        response = this.client.newRequest(cacheURL + "?action=stats").send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = objectMapper.readTree(response.getContent());
        AssertJUnit.assertEquals((int)jsonNode.get("current_number_of_entries").asInt(), (int)2);
        AssertJUnit.assertEquals((int)jsonNode.get("stores").asInt(), (int)2);
        response = this.client.newRequest(cacheURL + "?action=clear").send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(cacheURL + "?action=stats").send();
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((int)objectMapper.readTree(response.getContent()).get("current_number_of_entries").asInt(), (int)0);
    }

    @Test
    public void testCacheSize() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.putInCache("default", i, "" + i, "application/json");
        }
        String URL2 = String.format("http://localhost:%d/rest/v2/caches/default?action=size", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(URL2).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("100");
    }

    @Test
    public void testCacheNames() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String URL2 = String.format("http://localhost:%d/rest/v2/caches/", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(URL2).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = objectMapper.readTree(response.getContent());
        Set cacheNames = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheNames();
        AssertJUnit.assertEquals((int)cacheNames.size(), (int)jsonNode.size());
        for (int i = 0; i < jsonNode.size(); ++i) {
            AssertJUnit.assertTrue((boolean)cacheNames.contains(jsonNode.get(i).asText()));
        }
    }

    @Test
    public void testFlags() throws Exception {
        this.registerSchema();
        ContentResponse response = this.insertEntity(1, 1000, new String[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertIndexed(1000);
        response = this.insertEntity(2, 1200, Flag.SKIP_INDEXING.toString(), Flag.SKIP_CACHE_LOAD.toString());
        ResponseAssertion.assertThat(response).isOk();
        this.assertNotIndexed(1200);
        response = this.insertEntity(3, 1200, "Invalid");
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testGetAllKeys() throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/caches/default?action=%s", this.restServer().getPort(), "keys");
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.GET).send();
        Set emptyKeys = (Set)new ObjectMapper().readValue(response.getContentAsString(), Set.class);
        AssertJUnit.assertEquals((int)0, (int)emptyKeys.size());
        this.putStringValueInCache("default", "1", "value");
        response = this.client.newRequest(url).method(HttpMethod.GET).send();
        Set singleSet = (Set)new ObjectMapper().readValue(response.getContentAsString(), Set.class);
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        int entries = 1000;
        for (int i = 0; i < entries; ++i) {
            this.putStringValueInCache("default", String.valueOf(i), "value");
        }
        response = this.client.newRequest(url).method(HttpMethod.GET).send();
        Set keys = (Set)new ObjectMapper().readValue(response.getContentAsString(), Set.class);
        AssertJUnit.assertEquals((int)entries, (int)keys.size());
        AssertJUnit.assertTrue((boolean)IntStream.range(0, entries).allMatch(keys::contains));
    }

    @Test
    public void testGetAllKeysTextPlainCache() throws Exception {
        String cache = "___protobuf_metadata";
        String url = String.format("http://localhost:%d/rest/v2/caches/%s?action=%s", this.restServer().getPort(), cache, "keys");
        this.putStringValueInCache(cache, "file1.proto", "message A{}");
        this.putStringValueInCache(cache, "file2.proto", "message B{}");
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.GET).send();
        String contentAsString = response.getContentAsString();
        Set keys = (Set)new ObjectMapper().readValue(contentAsString, Set.class);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
    }

    @Test
    public void testJSONConversion() throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/caches?action=toJSON", this.restServer().getPort());
        String xml = "<infinispan>\n    <cache-container>\n        <distributed-cache name=\"cacheName\" mode=\"SYNC\">\n            <memory>\n                <object size=\"20\"/>\n            </memory>\n        </distributed-cache>\n    </cache-container>\n</infinispan>";
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(xml)).send();
        ResponseAssertion.assertThat(response).isOk();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(response.getContentAsString());
        JsonNode distCache = jsonNode.get("distributed-cache");
        JsonNode memory = distCache.get("memory");
        JsonNode object = memory.get("object");
        AssertJUnit.assertEquals((String)"SYNC", (String)distCache.get("mode").asText());
        AssertJUnit.assertEquals((int)20, (int)object.get("size").asInt());
    }

    private void registerSchema() throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/caches/___protobuf_metadata/sample.proto", this.restServer().getPort());
        String proto = "/* @Indexed */ message Entity { /* @Field */ required int32 value=1; }";
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.PUT).content((ContentProvider)new StringContentProvider(proto)).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    private ContentResponse insertEntity(int key, int value, String ... flags) throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/caches/indexedCache/%s", this.restServer().getPort(), key);
        String json = String.format("{\"_type\": \"Entity\",\"value\": %d}", value);
        Request req = this.client.newRequest(url).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(json)).header(HttpHeader.CONTENT_TYPE, "application/json");
        if (flags.length > 0) {
            req.header("flags", String.join((CharSequence)",", flags));
        }
        return req.send();
    }

    private void assertIndexed(int value) throws Exception {
        this.assertIndex(value, true);
    }

    private void assertNotIndexed(int value) throws Exception {
        this.assertIndex(value, false);
    }

    private void assertIndex(int value, boolean present) throws Exception {
        String query = URLEncoder.encode("FROM Entity where value = " + value);
        String url = String.format("http://localhost:%d/rest/v2/caches/indexedCache?action=search&query=%s", this.restServer().getPort(), query);
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((boolean)present, (boolean)response.getContentAsString().contains(String.valueOf(value)));
    }
}

