/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.ControlledTransport;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.Exceptions;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="rest.XSiteResourceTest")
public class XSiteResourceTest
extends AbstractMultipleSitesTest {
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final String SFO = "SFO-3";
    private static final String CACHE_1 = "CACHE_1";
    private static final String CACHE_2 = "CACHE_2";
    private static final String CACHE_MANAGER = "default";
    private Map<String, RestServerHelper> restServerPerSite = new HashMap<String, RestServerHelper>(2);
    private Map<String, RestClient> clientPerSite = new HashMap<String, RestClient>(2);
    private final ObjectMapper MAPPER = new ObjectMapper();

    protected int defaultNumberOfSites() {
        return 3;
    }

    protected int defaultNumberOfNodes() {
        return 1;
    }

    @BeforeClass
    public void startServers() {
        this.sites.forEach(site -> {
            String siteName = site.getSiteName();
            EmbeddedCacheManager cm = (EmbeddedCacheManager)site.cacheManagers().iterator().next();
            RestServerHelper restServerHelper = new RestServerHelper(cm);
            restServerHelper.start(TestResourceTracker.getCurrentTestShortName());
            this.restServerPerSite.put(siteName, restServerHelper);
            RestClientConfiguration clientConfig = new RestClientConfigurationBuilder().addServer().host("127.0.0.1").port(restServerHelper.getPort()).build();
            RestClient client = RestClient.forConfiguration((RestClientConfiguration)clientConfig);
            this.clientPerSite.put(siteName, client);
        });
    }

    private RestCacheClient getCacheClient(String site) {
        RestClient restClient = this.clientPerSite.get(site);
        return restClient.cache(CACHE_1);
    }

    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder configurationBuilder = super.defaultGlobalConfigurationForSite(siteIndex);
        configurationBuilder.cacheManagerName(CACHE_MANAGER);
        return configurationBuilder;
    }

    @AfterClass
    public void clean() {
        this.restServerPerSite.values().forEach(RestServerHelper::stop);
        this.clientPerSite.values().forEach(cli -> {
            try {
                cli.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @AfterMethod
    public void cleanCache() {
        XSiteResourceTest.sync(this.getCacheClient(LON).clear());
        XSiteResourceTest.sync(this.getCacheClient(NYC).clear());
    }

    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        return XSiteResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
    }

    @Test
    public void testObtainBackupStatus() throws Exception {
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, NYC));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, SFO));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(NYC, LON));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(NYC, SFO));
    }

    @Test
    public void testInvalidCache() {
        RestClient client = this.clientPerSite.get(LON);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.cache("invalid-cache").xsiteBackups());
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testInvalidSite() {
        RestClient client = this.clientPerSite.get(LON);
        RestCacheClient cache = client.cache(CACHE_1);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.backupStatus("invalid-site"));
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testOnlineOffline() throws Exception {
        this.testOnlineOffline(LON, NYC);
        this.testOnlineOffline(NYC, LON);
    }

    @Test
    public void testBackups() throws Exception {
        RestCacheClient cache = this.getCacheClient(LON);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.xsiteBackups());
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        JsonNode status = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((String)"online", (String)status.get(NYC).asText());
    }

    @Test
    public void testPushState() throws Exception {
        RestCacheClient cache = this.getCacheClient(LON);
        RestCacheClient backupCache = this.getCacheClient(NYC);
        String key = "key";
        String value = "value";
        Function<String, Integer> keyOnBackup = k -> ((RestResponse)XSiteResourceTest.sync(backupCache.get(key))).getStatus();
        this.takeBackupOffline(LON, NYC);
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus(LON, NYC));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, SFO));
        XSiteResourceTest.sync(cache.put(key, value));
        AssertJUnit.assertEquals((int)404, (int)keyOnBackup.apply(key));
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.pushSiteState(NYC));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        this.eventually(() -> this.getBackupStatus(LON, NYC).equals("online"));
        this.eventually(() -> (Integer)keyOnBackup.apply(key) == 200);
    }

    @Test
    public void testCancelPushState() throws Exception {
        RestCacheClient cache = this.getCacheClient(LON);
        RestCacheClient backupCache = this.getCacheClient(NYC);
        this.takeBackupOffline(LON, NYC);
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus(LON, NYC));
        int entries = 500;
        IntStream.range(0, entries).forEach(i -> XSiteResourceTest.sync(cache.put(String.valueOf(i), "value")));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache));
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(backupCache));
        ControlledTransport controllerTransport = ControlledTransport.replace((Cache)this.cache(LON, 0));
        controllerTransport.blockBefore(new Class[]{XSiteStatePushCommand.class});
        XSiteResourceTest.sync(cache.pushSiteState(NYC));
        controllerTransport.waitForCommandToBlock();
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.cancelPushState(NYC));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        controllerTransport.stopBlocking();
        JsonNode status = this.MAPPER.readTree(((RestResponse)XSiteResourceTest.sync(cache.pushStateStatus())).getBody());
        AssertJUnit.assertEquals((String)"CANCELED", (String)status.get(NYC).asText());
        response = (RestResponse)XSiteResourceTest.sync(cache.clearPushStateStatus());
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        status = this.MAPPER.readTree(((RestResponse)XSiteResourceTest.sync(cache.pushStateStatus())).getBody());
        Assert.assertTrue((boolean)status.isEmpty());
        response = (RestResponse)XSiteResourceTest.sync(cache.cancelReceiveState(NYC));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testTakeOfflineConfig() throws Exception {
        RestCacheClient cacheClient = this.getCacheClient(LON);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cacheClient.getXSiteTakeOfflineConfig(NYC));
        JsonNode takeOfflineConfig = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.get("after_failures").asInt());
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.get("min_wait").asInt());
        response = (RestResponse)XSiteResourceTest.sync(cacheClient.updateXSiteTakeOfflineConfig(NYC, 5, 1000L));
        AssertJUnit.assertEquals((int)204, (int)response.getStatus());
        response = (RestResponse)XSiteResourceTest.sync(cacheClient.getXSiteTakeOfflineConfig(NYC));
        takeOfflineConfig = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((int)5, (int)takeOfflineConfig.get("after_failures").asInt());
        AssertJUnit.assertEquals((int)1000, (int)takeOfflineConfig.get("min_wait").asInt());
    }

    @Test
    public void testInvalidInputTakeOffline() {
        RestClient restClient = this.clientPerSite.get(LON);
        String url = String.format("/rest/v2/caches/%s/x-site/backups/%s/take-offline-config", CACHE_1, NYC);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClient.raw().putValue(url, new HashMap(), "invalid", "application/json"));
        AssertJUnit.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testGetStatusAllCaches() throws Exception {
        RestClient restClient = this.clientPerSite.get(LON);
        this.assertAllSitesOnline(restClient, new String[0]);
        XSiteResourceTest.sync(restClient.cache(CACHE_2).takeSiteOffline(NYC));
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClient.cacheManager(CACHE_MANAGER).backupStatuses());
        JsonNode json = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((String)json.get(NYC).get("status").asText(), (String)"mixed");
        AssertJUnit.assertEquals((String)((JsonNode)json.get(NYC).get("online").elements().next()).asText(), (String)CACHE_1);
        AssertJUnit.assertEquals((String)((JsonNode)json.get(NYC).get("offline").elements().next()).asText(), (String)CACHE_2);
        XSiteResourceTest.sync(restClient.cache(CACHE_2).bringSiteOnline(NYC));
        this.assertAllSitesOnline(restClient, new String[0]);
    }

    @Test
    public void testBringAllCachesOnlineOffline() throws Exception {
        RestClient restClient = this.clientPerSite.get(LON);
        RestCacheManagerClient restCacheManagerClient = restClient.cacheManager(CACHE_MANAGER);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restCacheManagerClient.takeOffline(SFO));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        response = (RestResponse)XSiteResourceTest.sync(restCacheManagerClient.backupStatuses());
        JsonNode json = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((String)json.get(SFO).get("status").asText(), (String)"offline");
        XSiteResourceTest.sync(restCacheManagerClient.bringBackupOnline(SFO));
        response = (RestResponse)XSiteResourceTest.sync(restCacheManagerClient.backupStatuses());
        json = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((String)json.get(SFO).get("status").asText(), (String)"online");
    }

    @Test
    public void testPushAllCaches() throws Exception {
        RestClient restClientLon = this.clientPerSite.get(LON);
        RestClient restClientSfo = this.clientPerSite.get(SFO);
        RestCacheClient cache1Lon = restClientLon.cache(CACHE_1);
        RestCacheClient cache2Lon = restClientLon.cache(CACHE_2);
        RestCacheClient cache1Sfo = restClientSfo.cache(CACHE_1);
        RestCacheClient cache2Sfo = restClientSfo.cache(CACHE_2);
        XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).takeOffline(SFO));
        RestResponse statusResponse = (RestResponse)XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).backupStatuses());
        AssertJUnit.assertEquals((String)"offline", (String)this.MAPPER.readTree(statusResponse.getBody()).get(SFO).get("status").asText());
        int entries = 10;
        IntStream.range(0, entries).forEach(i -> {
            String key = String.valueOf(i);
            String value = "value";
            XSiteResourceTest.sync(cache1Lon.put(key, value));
            XSiteResourceTest.sync(cache2Lon.put(key, value));
        });
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(cache1Sfo));
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(cache2Sfo));
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).pushSiteState(SFO));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        this.eventually(() -> {
            RestResponse restResponse = (RestResponse)XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).backupStatuses());
            String status = this.MAPPER.readTree(restResponse.getBody()).get(SFO).get("status").asText();
            return "online".equals(status);
        });
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache1Sfo));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache2Sfo));
    }

    @Test
    public void testCancelPushAllCaches() throws Exception {
        RestClient restClientLon = this.clientPerSite.get(LON);
        RestCacheClient cache1Lon = restClientLon.cache(CACHE_1);
        RestCacheClient cache2Lon = restClientLon.cache(CACHE_2);
        XSiteResourceTest.sync(cache1Lon.put("k1", "v1"));
        XSiteResourceTest.sync(cache2Lon.put("k2", "v2"));
        ControlledTransport controlledTransport = ControlledTransport.replace((Cache)this.cache(LON, CACHE_1, 0));
        controlledTransport.blockBefore(new Class[]{XSiteStatePushCommand.class});
        XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).pushSiteState(SFO));
        controlledTransport.waitForCommandToBlock();
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClientLon.cacheManager(CACHE_MANAGER).cancelPushState(SFO));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        controlledTransport.stopBlocking();
        JsonNode pushStatusCache1 = this.MAPPER.readTree(((RestResponse)XSiteResourceTest.sync(cache1Lon.pushStateStatus())).getBody());
        JsonNode pushStatusCache2 = this.MAPPER.readTree(((RestResponse)XSiteResourceTest.sync(cache2Lon.pushStateStatus())).getBody());
        AssertJUnit.assertEquals((String)"CANCELED", (String)pushStatusCache1.get(SFO).asText());
        AssertJUnit.assertEquals((String)"CANCELED", (String)pushStatusCache2.get(SFO).asText());
    }

    private int getCacheSize(RestCacheClient cacheClient) {
        return Integer.parseInt(((RestResponse)XSiteResourceTest.sync(cacheClient.size())).getBody());
    }

    private void testOnlineOffline(String site, String backup) throws Exception {
        this.takeBackupOffline(site, backup);
        String siteStatus = this.getBackupStatus(site, backup);
        AssertJUnit.assertEquals((String)siteStatus, (String)"offline");
        this.bringBackupOnline(site, backup);
        siteStatus = this.getBackupStatus(site, backup);
        AssertJUnit.assertEquals((String)siteStatus, (String)"online");
    }

    private void takeBackupOffline(String site, String backup) {
        RestCacheClient client = this.getCacheClient(site);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.takeSiteOffline(backup));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    private void bringBackupOnline(String site, String backup) {
        RestCacheClient client = this.getCacheClient(site);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.bringSiteOnline(backup));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    private String getFirstCacheManagerAddress(String site) {
        AbstractXSiteTest.TestSite testSite = this.sites.stream().filter(t -> t.getSiteName().equals(site)).findFirst().orElse(null);
        if (testSite == null) {
            return null;
        }
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)testSite.cacheManagers().iterator().next();
        return cacheManager.getAddress().toString();
    }

    private String getBackupStatus(String site, String backup) throws Exception {
        RestCacheClient cacheClient = this.getCacheClient(site);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cacheClient.backupStatus(backup));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        JsonNode json = this.MAPPER.readTree(response.getBody());
        String cacheManagerAddress = this.getFirstCacheManagerAddress(site);
        return json.get(cacheManagerAddress).asText();
    }

    private void assertAllSitesOnline(RestClient restClient, String ... sites) throws Exception {
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClient.cacheManager(CACHE_MANAGER).backupStatuses());
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        JsonNode json = this.MAPPER.readTree(response.getBody());
        Arrays.stream(sites).forEach(s -> AssertJUnit.assertEquals((String)json.get(s).get("status").asText(), (String)"online"));
    }

    public static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }

    protected void afterSitesCreated() {
        ConfigurationBuilder builder = this.defaultConfigurationForSite(0);
        builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(0), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(0), (String)CACHE_2, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(2), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(2), (String)CACHE_2, (Configuration)builder.build());
        this.site(0).waitForClusterToForm(CACHE_1);
        this.site(0).waitForClusterToForm(CACHE_2);
        this.site(2).waitForClusterToForm(CACHE_1);
        this.site(2).waitForClusterToForm(CACHE_2);
        builder = this.defaultConfigurationForSite(1);
        builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC);
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(1), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(1), (String)CACHE_2, (Configuration)builder.build());
        this.site(1).waitForClusterToForm(CACHE_1);
        this.site(1).waitForClusterToForm(CACHE_2);
    }
}

