/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import com.fasterxml.jackson.databind.JsonNode;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.search.BaseRestSearchTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.IndexedRestSearchTest")
public class IndexedRestSearchTest
extends BaseRestSearchTest {
    @Override
    ConfigurationBuilder getConfigBuilder() {
        ConfigurationBuilder configurationBuilder = IndexedRestSearchTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        configurationBuilder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName());
        return configurationBuilder;
    }

    @Test
    public void testReplaceIndexedDocument() throws Exception {
        this.put(10, this.createPerson(0, "P", "", "?", "?", "MALE", new int[0]).toString());
        this.put(10, this.createPerson(0, "P", "Surname", "?", "?", "MALE", new int[0]).toString());
        ContentResponse response = this.get("10", "application/json");
        JsonNode person = MAPPER.readTree(response.getContentAsString());
        AssertJUnit.assertEquals((String)"Surname", (String)person.get("surname").asText());
    }

    @Test
    public void testCORS() throws Exception {
        String searchUrl = this.getUrl(this.pickServer());
        ContentResponse preFlight = this.client.newRequest(searchUrl).method(HttpMethod.OPTIONS).header(HttpHeader.HOST, "localhost").header(HttpHeader.ORIGIN, "http://localhost:11222").header("access-control-request-method", "GET").send();
        ResponseAssertion.assertThat(preFlight).isOk();
        ResponseAssertion.assertThat(preFlight).hasNoContent();
        ResponseAssertion.assertThat(preFlight).containsAllHeaders("access-control-allow-origin", "access-control-allow-methods");
    }
}

