/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.StaticResourceTest")
public class StaticResourceTest
extends AbstractRestResourceTest {
    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
    }

    private ContentResponse call(String context, String path) throws InterruptedException, ExecutionException, TimeoutException {
        String format = path == null ? "http://localhost:%d/%s" : "http://localhost:%d/%s/%s";
        String url = String.format(format, this.restServer().getPort(), context, path);
        this.client.getContentDecoderFactories().clear();
        return this.client.newRequest(url).method(HttpMethod.GET).send();
    }

    @Test
    public void testGetFile() throws InterruptedException, ExecutionException, TimeoutException {
        ContentResponse response = this.call("static", "nonexistent.html");
        ResponseAssertion.assertThat(response).isNotFound();
        response = this.call("static", "");
        this.assertResponse(response, "static-test/index.html", "<h1>Hello</h1>", MediaType.TEXT_HTML);
        response = this.call("static", "index.html");
        this.assertResponse(response, "static-test/index.html", "<h1>Hello</h1>", MediaType.TEXT_HTML);
        response = this.call("static", "xml/file.xml");
        this.assertResponse(response, "static-test/xml/file.xml", "<distributed-cache", MediaType.fromString((String)"text/xml"), MediaType.APPLICATION_XML);
        response = this.call("static", "other/text/file.txt");
        this.assertResponse(response, "static-test/other/text/file.txt", "This is a text file", MediaType.TEXT_PLAIN);
    }

    @Test
    public void testConsole() throws Exception {
        ContentResponse response1 = this.call("console", "page.htm");
        ContentResponse response2 = this.call("console", "folder/test.css");
        ContentResponse response3 = this.call("console", null);
        this.assertResponse(response1, "static-test/console/page.htm", "console", MediaType.TEXT_HTML);
        this.assertResponse(response2, "static-test/console/folder/test.css", ".a", MediaType.TEXT_CSS);
        ResponseAssertion.assertThat(response2).isOk();
        this.assertResponse(response3, "static-test/console/index.html", "console", MediaType.TEXT_HTML);
    }

    private void assertResponse(ContentResponse response, String path, String returnedText, MediaType ... possibleTypes) {
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasMediaType(possibleTypes);
        ResponseAssertion.assertThat(response).containsReturnedText(returnedText);
        this.assertCacheHeaders(path, response);
        ResponseAssertion.assertThat(response).hasValidDate();
    }

    private void assertCacheHeaders(String path, ContentResponse response) {
        int expireDuration = 2678400;
        File test = StaticResourceTest.getTestFile(path);
        AssertJUnit.assertNotNull((Object)test);
        ResponseAssertion.assertThat(response).hasContentLength(test.length());
        ResponseAssertion.assertThat(response).hasLastModified(test.lastModified());
        ResponseAssertion.assertThat(response).hasCacheControlHeaders("private, max-age=" + expireDuration);
        ResponseAssertion.assertThat(response).expiresAfter(expireDuration);
    }

    @Test
    public void testCacheHeaders() throws InterruptedException, ExecutionException, TimeoutException {
        String url = String.format("http://localhost:%d/static/index.html", this.restServer().getPort());
        long lastModified = StaticResourceTest.getTestFile("static-test/index.html").lastModified();
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.GET).header("If-Modified-Since", DateUtils.toRFC1123((long)lastModified)).send();
        ResponseAssertion.assertThat(response).isNotModified();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = this.client.newRequest(url).method(HttpMethod.GET).header("If-Modified-Since", "Sun, 15 Aug 1971 15:00:00 GMT").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("<h1>Hello</h1>");
        response = this.client.newRequest(url).method(HttpMethod.GET).header("If-Modified-Since", DateUtils.toRFC1123((long)System.currentTimeMillis())).send();
        ResponseAssertion.assertThat(response).isNotModified();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testRedirect() throws Exception {
        String url = String.format("http://localhost:%d/", this.restServer().getPort());
        this.client.getContentDecoderFactories().clear();
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.GET).followRedirects(false).send();
        ResponseAssertion.assertThat(response).isRedirect();
        AssertJUnit.assertEquals((String)"/console/welcome", (String)response.getHeaders().get("Location"));
    }

    private static File getTestFile(String path) {
        URL resource = StaticResourceTest.class.getClassLoader().getResource(path);
        try {
            Path p = Paths.get(resource.toURI());
            return p.toFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

