/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Base64;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.AuthenticationTest")
public class AuthenticationTest
extends AbstractInfinispanTest {
    private HttpClient client;
    private RestServerHelper restServer;

    @BeforeClass
    public void beforeSuite() throws Exception {
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterClass(alwaysRun=true)
    public void afterSuite() throws Exception {
        this.client.stop();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        this.restServer.clear();
        if (this.restServer != null) {
            this.restServer.stop();
        }
    }

    @Test
    public void shouldAuthenticateWhenProvidingProperCredentials() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        Subject user = TestingUtil.makeSubject((String[])new String[]{"test"});
        ((SecurityDomain)Mockito.doReturn((Object)user).when((Object)securityDomainMock)).authenticate((String)Matchers.eq((Object)"test"), (String)Matchers.eq((Object)"test"));
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start(TestResourceTracker.getCurrentTestShortName());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.HEAD).header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString("test:test".getBytes())).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldRejectNotValidAuthorizationString() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start(TestResourceTracker.getCurrentTestShortName());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).header(HttpHeader.AUTHORIZATION, "Invalid string").send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldRejectNoAuthentication() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start(TestResourceTracker.getCurrentTestShortName());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldAllowHealthAnonymously() throws InterruptedException, ExecutionException, TimeoutException {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        Subject user = TestingUtil.makeSubject((String[])new String[]{"test"});
        ((SecurityDomain)Mockito.doReturn((Object)user).when((Object)securityDomainMock)).authenticate((String)Matchers.eq((Object)"test"), (String)Matchers.eq((Object)"test"));
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start(TestResourceTracker.getCurrentTestShortName());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/cache-managers/DefaultCacheManager/health/status", this.restServer.getPort())).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("HEALTHY");
    }
}

