/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.security.auth.Subject;
import org.infinispan.rest.BaseHttpRequestHandler;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RestRequestHandler
extends BaseHttpRequestHandler {
    protected static final Log logger = (Log)LogFactory.getLog(RestRequestHandler.class, Log.class);
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;
    private final String context;
    private Subject subject;
    private String authorization;
    private final Authenticator authenticator;

    RestRequestHandler(RestServer restServer) {
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.authenticator = this.configuration.authentication().enabled() ? this.configuration.authentication().authenticator() : null;
        this.context = this.configuration.contextPath();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        NettyRestRequest restRequest;
        this.restAccessLoggingHandler.preLog(request);
        if (!Method.contains(request.getMethod().name())) {
            NettyRestResponse restResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.FORBIDDEN).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        try {
            restRequest = new NettyRestRequest(request);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            NettyRestResponse restResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        LookupResult invocationLookup = this.restServer.getRestDispatcher().lookupInvocation(restRequest);
        if (this.authenticator == null || this.isAnon(invocationLookup)) {
            this.handleRestRequest(ctx, restRequest, invocationLookup);
            return;
        }
        if (this.subject != null) {
            String authz = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
            if (Objects.equals(authz, this.authorization)) {
                this.handleRestRequest(ctx, restRequest, invocationLookup);
                return;
            }
            this.subject = null;
            this.authorization = null;
        }
        this.authenticator.challenge(restRequest, ctx).whenComplete((authResponse, authThrowable) -> {
            boolean authorized;
            boolean hasError = authThrowable != null;
            boolean bl = authorized = authResponse.getStatus() != HttpResponseStatus.UNAUTHORIZED.code();
            if (!hasError && authorized) {
                this.subject = restRequest.getSubject();
                this.authorization = restRequest.getAuthorizationHeader();
                restRequest.setSubject(this.subject);
                this.handleRestRequest(ctx, restRequest, invocationLookup);
            } else {
                try {
                    if (hasError) {
                        this.handleError(ctx, request, (Throwable)authThrowable);
                    } else {
                        this.sendResponse(ctx, request, (NettyRestResponse)authResponse);
                    }
                }
                finally {
                    request.release();
                }
            }
        });
    }

    private boolean isAnon(LookupResult lookupResult) {
        if (lookupResult == null || lookupResult.getInvocation() == null) {
            return true;
        }
        return lookupResult.getInvocation().anonymous();
    }

    private void handleRestRequest(ChannelHandlerContext ctx, NettyRestRequest restRequest, LookupResult invocationLookup) {
        this.restServer.getRestDispatcher().dispatch(restRequest, invocationLookup).whenComplete((restResponse, throwable) -> {
            FullHttpRequest request = restRequest.getFullHttpRequest();
            try {
                if (throwable == null) {
                    NettyRestResponse nettyRestResponse = (NettyRestResponse)restResponse;
                    this.addCorrelatedHeaders(request, nettyRestResponse.getResponse());
                    this.sendResponse(ctx, request, nettyRestResponse);
                } else {
                    this.handleError(ctx, request, (Throwable)throwable);
                }
            }
            finally {
                request.release();
            }
        });
    }

    private void addCorrelatedHeaders(FullHttpRequest request, HttpResponse response) {
        String streamId = request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            response.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpVersion = response.protocolVersion();
        if ((httpVersion == HttpVersion.HTTP_1_1 || httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debug("Native IO Exception", e);
            ctx.close();
        } else {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

