/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.context.Flag;
import org.infinispan.rest.ByteBufContentSource;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.InvalidFlagException;
import org.infinispan.util.logging.LogFactory;

public class NettyRestRequest
implements RestRequest {
    private static final Log logger = (Log)LogFactory.getLog(NettyRestRequest.class, Log.class);
    private static final MediaType DEFAULT_KEY_CONTENT_TYPE = MediaType.fromString((String)"application/x-java-object;type=java.lang.String");
    public static final String EXTENDED_HEADER = "extended";
    private static final String MAX_TIME_IDLE_HEADER = "maxIdleTimeSeconds";
    private static final String CREATED_HEADER = "created";
    private static final String LAST_USED_HEADER = "lastUsed";
    private static final String TTL_SECONDS_HEADER = "timeToLiveSeconds";
    private static final String KEY_CONTENT_TYPE_HEADER = "key-content-type";
    private static final String FLAGS_HEADER = "flags";
    private final FullHttpRequest request;
    private final Map<String, List<String>> parameters;
    private final String path;
    private final ContentSource contentSource;
    private final String context;
    private String action;
    private Subject subject;
    private Map<String, String> variables;

    private String getPath(String uri) {
        int lastSeparatorIdx = -1;
        int paramsSeparatorIdx = -1;
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                lastSeparatorIdx = i;
            }
            if (c != '?') continue;
            paramsSeparatorIdx = i;
        }
        String baseURI = uri.substring(0, lastSeparatorIdx);
        String resourceName = uri.substring(lastSeparatorIdx + 1, paramsSeparatorIdx != -1 ? paramsSeparatorIdx : uri.length());
        String decodedPath = QueryStringDecoder.decodeComponent((String)baseURI);
        return decodedPath + "/" + resourceName;
    }

    NettyRestRequest(FullHttpRequest request) throws IllegalArgumentException {
        this.request = request;
        String uri = request.uri();
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        this.parameters = queryStringDecoder.parameters();
        this.path = this.getPath(uri);
        this.context = this.getContext(this.path);
        List action = (List)queryStringDecoder.parameters().get("action");
        if (action != null) {
            this.action = (String)action.iterator().next();
        }
        this.contentSource = new ByteBufContentSource(request.content());
    }

    private String getContext(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("/") || path.length() == 1) {
            return "";
        }
        int endIndex = path.indexOf("/", 1);
        return path.substring(1, endIndex == -1 ? path.length() : endIndex);
    }

    public String getContext() {
        return this.context;
    }

    @Override
    public Method method() {
        return Method.valueOf(this.request.method().name());
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.request.uri();
    }

    @Override
    public String header(String name) {
        return this.request.headers().get(name);
    }

    @Override
    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    @Override
    public ContentSource contents() {
        return this.contentSource;
    }

    @Override
    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    @Override
    public String getParameter(String name) {
        if (this.parameters == null || !this.parameters.containsKey(name)) {
            return null;
        }
        List<String> values = this.parameters.get(name);
        return values.get(values.size() - 1);
    }

    @Override
    public Map<String, String> variables() {
        return this.variables;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public MediaType contentType() {
        String contentTypeHeader = this.getContentTypeHeader();
        if (contentTypeHeader == null) {
            return MediaType.MATCH_ALL;
        }
        return MediaType.fromString((String)contentTypeHeader);
    }

    @Override
    public MediaType keyContentType() {
        String header = this.request.headers().get(KEY_CONTENT_TYPE_HEADER);
        if (header == null) {
            return DEFAULT_KEY_CONTENT_TYPE;
        }
        return MediaType.fromString((String)header);
    }

    @Override
    public String getAcceptHeader() {
        String accept = this.request.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        return accept == null ? "*/*" : accept;
    }

    @Override
    public String getAuthorizationHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
    }

    @Override
    public String getCacheControlHeader() {
        String value = this.request.headers().get((CharSequence)HttpHeaderNames.CACHE_CONTROL);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getContentTypeHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    @Override
    public String getEtagIfMatchHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.IF_MATCH);
    }

    @Override
    public String getIfModifiedSinceHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
    }

    @Override
    public String getEtagIfNoneMatchHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
    }

    @Override
    public String getIfUnmodifiedSinceHeader() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.IF_UNMODIFIED_SINCE);
    }

    @Override
    public Long getMaxIdleTimeSecondsHeader() {
        return this.getHeaderAsLong(MAX_TIME_IDLE_HEADER);
    }

    @Override
    public Long getTimeToLiveSecondsHeader() {
        return this.getHeaderAsLong(TTL_SECONDS_HEADER);
    }

    @Override
    public EnumSet<CacheContainerAdmin.AdminFlag> getAdminFlags() {
        String requestFlags = this.request.headers().get(FLAGS_HEADER);
        if (requestFlags == null || requestFlags.isEmpty()) {
            return null;
        }
        try {
            return CacheContainerAdmin.AdminFlag.fromString((String)requestFlags);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagException(e);
        }
    }

    @Override
    public Flag[] getFlags() {
        try {
            String flags = this.request.headers().get(FLAGS_HEADER);
            if (flags == null || flags.isEmpty()) {
                return null;
            }
            return (Flag[])Arrays.stream(flags.split(",")).filter(s -> !s.isEmpty()).map(Flag::valueOf).toArray(Flag[]::new);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagException(e);
        }
    }

    @Override
    public Long getCreatedHeader() {
        return this.getHeaderAsLong(CREATED_HEADER);
    }

    @Override
    public Long getLastUsedHeader() {
        return this.getHeaderAsLong(LAST_USED_HEADER);
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @Override
    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    private boolean getHeaderAsBoolean(String header) {
        String headerValue = this.request.headers().get(header);
        if (header == null) {
            return false;
        }
        return Boolean.valueOf(headerValue);
    }

    private Long getHeaderAsLong(String header) {
        String headerValue = this.request.headers().get(header);
        if (headerValue == null) {
            return null;
        }
        try {
            return Long.valueOf(headerValue);
        }
        catch (NumberFormatException e) {
            logger.warnInvalidNumber(header, headerValue);
            return null;
        }
    }

    public FullHttpRequest getFullHttpRequest() {
        return this.request;
    }

    public String toString() {
        return "NettyRestRequest{" + this.request.method().name() + " " + this.request.uri() + ", subject=" + this.subject + '}';
    }
}

