/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.io.IOException;
import java.nio.file.Path;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.resources.CacheManagerResource;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.rest.resources.CacheResourceV2;
import org.infinispan.rest.resources.ClusterResource;
import org.infinispan.rest.resources.CounterResource;
import org.infinispan.rest.resources.LoginResource;
import org.infinispan.rest.resources.MetricsResource;
import org.infinispan.rest.resources.RedirectResource;
import org.infinispan.rest.resources.SearchAdminResource;
import org.infinispan.rest.resources.ServerResource;
import org.infinispan.rest.resources.StaticContentResource;
import org.infinispan.rest.resources.TasksResource;
import org.infinispan.rest.resources.XSiteResource;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private ServerManagement server;
    private RestDispatcher restDispatcher;
    private RestCacheManager<Object> restCacheManager;
    private InvocationHelper invocationHelper;

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{this.getRestChannelInitializer()});
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    RestDispatcher getRestDispatcher() {
        return this.restDispatcher;
    }

    public void stop() {
        AuthenticationConfiguration auth;
        if (this.restCacheManager != null) {
            this.restCacheManager.stop();
        }
        if ((auth = ((RestServerConfiguration)this.configuration).authentication()).enabled()) {
            try {
                auth.authenticator().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.stop();
    }

    public void setServer(ServerManagement server) {
        this.server = server;
    }

    protected void startInternal() {
        AuthenticationConfiguration auth = ((RestServerConfiguration)this.configuration).authentication();
        if (auth.enabled()) {
            auth.authenticator().init(this);
        }
        super.startInternal();
        this.restCacheManager = new RestCacheManager(this.cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        this.invocationHelper = new InvocationHelper(this.restCacheManager, (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager), (RestServerConfiguration)this.configuration, this.server, this.getExecutor());
        String restContext = ((RestServerConfiguration)this.configuration).contextPath();
        String rootContext = "/";
        ResourceManagerImpl resourceManager = new ResourceManagerImpl();
        resourceManager.registerResource(restContext, new CacheResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new CacheResourceV2(this.invocationHelper));
        resourceManager.registerResource(restContext, new CounterResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new CacheManagerResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new XSiteResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new SearchAdminResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new TasksResource(this.invocationHelper));
        resourceManager.registerResource(rootContext, new MetricsResource());
        Path staticResources = ((RestServerConfiguration)this.configuration).staticResources();
        if (staticResources != null) {
            Path console = ((RestServerConfiguration)this.configuration).staticResources().resolve("console");
            resourceManager.registerResource(rootContext, new StaticContentResource(staticResources, "static"));
            resourceManager.registerResource(rootContext, new StaticContentResource(console, "console"));
            resourceManager.registerResource(rootContext, new RedirectResource(rootContext, rootContext + "console/welcome", true));
        }
        if (this.server != null) {
            resourceManager.registerResource(restContext, new ServerResource(this.invocationHelper));
            resourceManager.registerResource(restContext, new ClusterResource(this.invocationHelper));
            resourceManager.registerResource(restContext, new LoginResource(this.invocationHelper, rootContext + "console/", rootContext + "console/forbidden.html"));
        }
        this.restDispatcher = new RestDispatcherImpl(resourceManager);
    }
}

