/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SearchAdminResource
implements ResourceHandler {
    private static final Log LOG = (Log)LogFactory.getLog(SearchAdminResource.class, Log.class);
    private final InvocationHelper invocationHelper;

    public SearchAdminResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes").withAction("mass-index").handleWith(this::massIndex).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes").withAction("clear").handleWith(this::clearIndexes).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes/stats").handleWith(this::indexStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/query/stats").handleWith(this::queryStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/query/stats").withAction("clear").handleWith(this::clearStats).create();
    }

    private CompletionStage<RestResponse> massIndex(RestRequest request) {
        return this.runMassIndexer(request, MassIndexer::startAsync, true);
    }

    private CompletionStage<RestResponse> clearIndexes(RestRequest request) {
        return this.runMassIndexer(request, MassIndexer::purge, false);
    }

    private CompletionStage<RestResponse> indexStats(RestRequest request) {
        return this.showStats(request, InfinispanQueryStatisticsInfo::getIndexStatistics);
    }

    private CompletionStage<RestResponse> queryStats(RestRequest request) {
        return this.showStats(request, InfinispanQueryStatisticsInfo::getQueryStatistics);
    }

    private CompletionStage<RestResponse> clearStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        InfinispanQueryStatisticsInfo queryStatistics = this.lookupQueryStatistics(request, responseBuilder);
        if (queryStatistics == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        queryStatistics.clear();
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> runMassIndexer(RestRequest request, Function<MassIndexer, CompletableFuture<Void>> op, boolean supportAsync) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        List<String> mode = request.parameters().get("mode");
        boolean asyncParams = mode != null && !mode.isEmpty() && mode.iterator().next().equalsIgnoreCase("async");
        boolean async = asyncParams && supportAsync;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, responseBuilder);
        if (responseBuilder.getStatus() != HttpResponseStatus.OK.code()) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        MassIndexer massIndexer = ComponentRegistryUtils.getMassIndexer(cache);
        if (async) {
            try {
                LOG.asyncMassIndexerStarted();
                op.apply(massIndexer).whenComplete((v, e) -> {
                    if (e == null) {
                        LOG.asyncMassIndexerSuccess();
                    } else {
                        LOG.errorExecutingMassIndexer(e.getCause());
                    }
                });
            }
            catch (Exception e2) {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).entity("Error executing the MassIndexer " + e2.getCause());
            }
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ((CompletableFuture)op.apply(massIndexer).exceptionally(e -> {
            if (e instanceof MassIndexerAlreadyStartedException) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST.code()).entity("MassIndexer already started");
            } else {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).entity("Error executing the MassIndexer " + e.getCause());
            }
            return null;
        })).thenApply(v -> responseBuilder.build());
    }

    private CompletionStage<RestResponse> showStats(RestRequest request, Function<InfinispanQueryStatisticsInfo, Object> statExtractor) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        InfinispanQueryStatisticsInfo searchStats = this.lookupQueryStatistics(request, responseBuilder);
        if (searchStats == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        try {
            byte[] bytes = this.invocationHelper.getMapper().writeValueAsBytes(statExtractor.apply(searchStats));
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private AdvancedCache<?, ?> lookupIndexedCache(RestRequest request, NettyRestResponse.Builder builder) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            builder.status(HttpResponseStatus.NOT_FOUND.code());
            return null;
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        if (!cacheConfiguration.indexing().index().isEnabled()) {
            builder.entity("cache is not indexed").status(HttpResponseStatus.BAD_REQUEST.code());
        }
        return cache;
    }

    private AdvancedCache<?, ?> lookupCacheWithStats(RestRequest request, NettyRestResponse.Builder builder) {
        Configuration cacheConfiguration;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, builder);
        if (cache != null && !(cacheConfiguration = cache.getCacheConfiguration()).statistics().enabled()) {
            builder.entity("statistics not enabled").status(HttpResponseStatus.BAD_REQUEST.code());
        }
        return cache;
    }

    private InfinispanQueryStatisticsInfo lookupQueryStatistics(RestRequest request, NettyRestResponse.Builder builder) {
        AdvancedCache<?, ?> cache = this.lookupCacheWithStats(request, builder);
        if (builder.getStatus() != HttpResponseStatus.OK.code()) {
            return null;
        }
        return ComponentRegistryUtils.getQueryStatistics(cache);
    }
}

