package org.infinispan.rest.logging;

import java.util.Locale;
import org.infinispan.rest.framework.RegistrationException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.rest.framework.Invocation;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.framework.Method;
import org.jboss.logging.Logger;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import java.lang.Exception;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-02-11T10:07:13+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unsupportedConfigurationOption = "ISPN012004: Unsupported configuration option";
    protected String unsupportedConfigurationOption$str() {
        return unsupportedConfigurationOption;
    }
    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedConfigurationOption$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorWhileResponding(final Exception e) {
        super.log.logf(FQCN, TRACE, e, errorWhileResponding$str());
    }
    private static final String errorWhileResponding = "ISPN012005: An error occurred while responding to the client";
    protected String errorWhileResponding$str() {
        return errorWhileResponding;
    }
    @Override
    public final void uncaughtExceptionInThePipeline(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, uncaughtExceptionInThePipeline$str());
    }
    private static final String uncaughtExceptionInThePipeline = "ISPN012006: Uncaught exception in the pipeline";
    protected String uncaughtExceptionInThePipeline$str() {
        return uncaughtExceptionInThePipeline;
    }
    private static final String unsupportedDataFormat = "ISPN012007: Cannot convert to %s";
    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }
    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(final String mediaType) {
        final UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(getLoggingLocale(), unsupportedDataFormat$str(), mediaType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheUnavailable = "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    protected String cacheUnavailable$str() {
        return cacheUnavailable;
    }
    @Override
    public final ServiceUnavailableException cacheUnavailable(final String cacheName) {
        final ServiceUnavailableException result = new ServiceUnavailableException(String.format(getLoggingLocale(), cacheUnavailable$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredMediaType = "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    protected String missingRequiredMediaType$str() {
        return missingRequiredMediaType;
    }
    @Override
    public final NullPointerException missingRequiredMediaType(final String cacheName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), missingRequiredMediaType$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheNotFound = "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    protected String cacheNotFound$str() {
        return cacheNotFound;
    }
    @Override
    public final NoCacheFoundException cacheNotFound(final String cacheName) {
        final NoCacheFoundException result = new NoCacheFoundException(String.format(getLoggingLocale(), cacheNotFound$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requestNotAllowedToInternalCaches = "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    protected String requestNotAllowedToInternalCaches$str() {
        return requestNotAllowedToInternalCaches;
    }
    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(final String cacheName) {
        final CacheUnavailableException result = new CacheUnavailableException(String.format(getLoggingLocale(), requestNotAllowedToInternalCaches$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requestNotAllowedToInternalCachesWithoutAuthz = "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return requestNotAllowedToInternalCachesWithoutAuthz;
    }
    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(final String cacheName) {
        final CacheUnavailableException result = new CacheUnavailableException(String.format(getLoggingLocale(), requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCompressionLevel = "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";
    protected String illegalCompressionLevel$str() {
        return illegalCompressionLevel;
    }
    @Override
    public final CacheConfigurationException illegalCompressionLevel(final int compressionLevel) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), illegalCompressionLevel$str(), compressionLevel));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateResourceMethod = "ISPN012015: Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'";
    protected String duplicateResourceMethod$str() {
        return duplicateResourceMethod;
    }
    @Override
    public final RegistrationException duplicateResourceMethod(final String invocationName, final Method method, final String existingPath) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), duplicateResourceMethod$str(), invocationName, method, existingPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnInvalidNumber(final String header, final String value) {
        super.log.logf(FQCN, WARN, null, warnInvalidNumber$str(), header, value);
    }
    private static final String warnInvalidNumber = "ISPN012016: Header '%s' will be ignored, expecting a number but got '%s'";
    protected String warnInvalidNumber$str() {
        return warnInvalidNumber;
    }
    private static final String authenticationWithoutAuthenticator = "ISPN012017: Cannot enable authentication without an authenticator";
    protected String authenticationWithoutAuthenticator$str() {
        return authenticationWithoutAuthenticator;
    }
    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutAuthenticator$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPath = "ISPN012018: Cannot register invocation with path '%s': '*' is only allowed at the end";
    protected String invalidPath$str() {
        return invalidPath;
    }
    @Override
    public final RegistrationException invalidPath(final String path) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), invalidPath$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateResource = "ISPN012019: Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'";
    protected String duplicateResource$str() {
        return duplicateResource;
    }
    @Override
    public final RegistrationException duplicateResource(final String candidate, final Invocation invocation, final String existingPath) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), duplicateResource$str(), candidate, invocation, existingPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void asyncMassIndexerStarted() {
        super.log.logf(FQCN, INFO, null, asyncMassIndexerStarted$str());
    }
    private static final String asyncMassIndexerStarted = "ISPN012020: MassIndexer started";
    protected String asyncMassIndexerStarted$str() {
        return asyncMassIndexerStarted;
    }
    @Override
    public final void asyncMassIndexerSuccess() {
        super.log.logf(FQCN, INFO, null, asyncMassIndexerSuccess$str());
    }
    private static final String asyncMassIndexerSuccess = "ISPN012021: MassIndexer completed successfully";
    protected String asyncMassIndexerSuccess$str() {
        return asyncMassIndexerSuccess;
    }
    @Override
    public final void errorExecutingMassIndexer(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorExecutingMassIndexer$str());
    }
    private static final String errorExecutingMassIndexer = "ISPN012022: Error executing MassIndexer";
    protected String errorExecutingMassIndexer$str() {
        return errorExecutingMassIndexer;
    }
}
