/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.Arrays;
import java.util.Optional;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.encoding.DataConversion;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;

final class MediaTypeUtils {
    private MediaTypeUtils() {
    }

    static MediaType negotiateMediaType(RestRequest restRequest, MediaType ... accepted) {
        String acceptHeader = restRequest.getAcceptHeader();
        if (accepted.length == 0) {
            throw new IllegalArgumentException("Accepted should be provided");
        }
        if (acceptHeader.equals("*/*")) {
            return accepted[0];
        }
        Optional<MediaType> found = MediaType.parseList((String)acceptHeader).filter(c -> Arrays.stream(accepted).anyMatch(m -> m.match(c))).findFirst();
        return found.orElseThrow(() -> Log.REST.unsupportedDataFormat(acceptHeader));
    }

    static MediaType negotiateMediaType(AdvancedCache<?, ?> cache, RestRequest restRequest) throws UnacceptableDataFormatException {
        try {
            String accept = restRequest.getAcceptHeader();
            DataConversion valueDataConversion = cache.getValueDataConversion();
            Optional<MediaType> negotiated = MediaType.parseList((String)accept).filter(arg_0 -> ((DataConversion)valueDataConversion).isConversionSupported(arg_0)).findFirst();
            return negotiated.map(m -> {
                if (!m.matchesAll()) {
                    return m;
                }
                MediaType storageMediaType = cache.getValueDataConversion().getStorageMediaType();
                if (storageMediaType == null) {
                    return m;
                }
                if (storageMediaType.equals((Object)MediaType.APPLICATION_OBJECT)) {
                    return MediaType.TEXT_PLAIN;
                }
                if (storageMediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                    return MediaType.APPLICATION_JSON;
                }
                return m;
            }).orElseThrow(() -> Log.REST.unsupportedDataFormat(accept));
        }
        catch (EncodingException e) {
            throw new UnacceptableDataFormatException();
        }
    }
}

