/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.rest.client.NettyHttpClient;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.Http2Test")
public final class Http2Test
extends AbstractInfinispanTest {
    private static final String KEY_STORE_PATH = Http2Test.class.getClassLoader().getResource("./client.p12").getPath();
    private static final String CACHE_MANAGER_PATH = "/rest/v2/cache-managers/DefaultCacheManager";
    private NettyHttpClient client;
    private RestServerHelper restServer;

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void shouldUseHTTP1WithALPN() throws Exception {
        this.secureUpgradeTest(Protocol.HTTP_11);
    }

    @Test
    public void shouldUseHTTP2WithALPN() throws Exception {
        this.secureUpgradeTest(Protocol.HTTP_20);
    }

    @Test
    public void shouldUseHTTP2WithUpgrade() throws Exception {
        this.clearTextUpgrade(false);
    }

    @Test
    public void shouldUseHTTP2WithPriorKnowledge() throws Exception {
        this.clearTextUpgrade(true);
    }

    @Test
    public void shouldUseHTTP1() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_11);
        this.client = NettyHttpClient.forConfiguration(builder.build());
        DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, CACHE_MANAGER_PATH);
        FullHttpResponse response = this.client.sendRequest((FullHttpRequest)getRequest).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((int)response.status().code()).isEqualTo(200);
        DefaultFullHttpRequest postRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.restServer.getBasePath() + "/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        response = this.client.sendRequest((FullHttpRequest)postRequest).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((int)response.status().code()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void clearTextUpgrade(boolean previousKnowledge) throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).priorKnowledge(previousKnowledge).protocol(Protocol.HTTP_20);
        this.client = NettyHttpClient.forConfiguration(builder.build());
        DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, CACHE_MANAGER_PATH);
        FullHttpResponse response = this.client.sendRequest((FullHttpRequest)getRequest).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((int)response.status().code()).isEqualTo(200);
        DefaultFullHttpRequest postRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.restServer.getBasePath() + "/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        response = this.client.sendRequest((FullHttpRequest)postRequest).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((int)response.status().code()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void secureUpgradeTest(Protocol choice) throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withKeyStore(KEY_STORE_PATH, "secret", "pkcs12").start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(choice).security().ssl().trustStoreFileName(KEY_STORE_PATH).trustStorePassword("secret".toCharArray());
        this.client = NettyHttpClient.forConfiguration(builder.build());
        DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.restServer.getBasePath() + "/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        FullHttpResponse response = this.client.sendRequest((FullHttpRequest)putValueInCacheRequest).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((int)response.status().code()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }
}

