/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.test.Exceptions;

public class RestResponses {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void assertSuccessful(CompletionStage<RestResponse> responseStage) {
        RestResponses.assertStatus(200, responseStage);
    }

    public static void assertNoContent(CompletionStage<RestResponse> responseStage) {
        RestResponses.assertStatus(204, responseStage);
    }

    public static void assertStatus(int expectedStatus, CompletionStage<RestResponse> responseStage) {
        int status = RestResponses.responseStatus(responseStage);
        RestResponses.assertEquals(expectedStatus, status);
    }

    public static int responseStatus(CompletionStage<RestResponse> responseStage) {
        try (RestResponse response = RestResponses.sync(responseStage);){
            int n = response.getStatus();
            return n;
        }
    }

    public static String responseBody(CompletionStage<RestResponse> responseStage) {
        try (RestResponse response = RestResponses.sync(responseStage);){
            RestResponses.assertEquals(200, response.getStatus());
            String string = response.getBody();
            return string;
        }
    }

    public static JsonNode jsonResponseBody(CompletionStage<RestResponse> responseCompletionStage) {
        return (JsonNode)Exceptions.unchecked(() -> MAPPER.readTree(RestResponses.responseBody(responseCompletionStage)));
    }

    private static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(10L, TimeUnit.SECONDS));
    }

    private static void assertEquals(int expectedStatus, int status) {
        if (status != expectedStatus) {
            throw new AssertionError((Object)("Expected: <" + expectedStatus + ">, but was: <" + status + ">"));
        }
    }
}

