/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final Log REST = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.REST");

    @Message(value="Unsupported configuration option", id=12004)
    public UnsupportedOperationException unsupportedConfigurationOption();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="An error occurred while responding to the client", id=12005)
    public void errorWhileResponding(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Uncaught exception in the pipeline", id=12006)
    public void uncaughtExceptionInThePipeline(@Cause Throwable var1);

    @Message(value="Cannot convert to %s", id=12007)
    public UnacceptableDataFormatException unsupportedDataFormat(String var1);

    @Message(value="Cache with name '%s' is temporarily unavailable.", id=12008)
    public ServiceUnavailableException cacheUnavailable(String var1);

    @Message(value="Cannot obtain cache '%s', without required MediaType", id=12009)
    public NullPointerException missingRequiredMediaType(String var1);

    @Message(value="Cache with name '%s' not found amongst the configured caches", id=12010)
    public NoCacheFoundException cacheNotFound(String var1);

    @Message(value="Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", id=12011)
    public CacheUnavailableException requestNotAllowedToInternalCaches(String var1);

    @Message(value="Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'", id=12012)
    public CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String var1);

    @Message(value="Illegal compression level '%d'. The value must be >= 0 and <= 9", id=12014)
    public CacheConfigurationException illegalCompressionLevel(int var1);

    @Message(value="Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'", id=12015)
    public RegistrationException duplicateResourceMethod(String var1, Method var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Header '%s' will be ignored, expecting a number but got '%s'", id=12016)
    public void warnInvalidNumber(String var1, String var2);

    @Message(value="Cannot enable authentication without an authenticator", id=12017)
    public CacheConfigurationException authenticationWithoutAuthenticator();

    @Message(value="Cannot register invocation with path '%s': '*' is only allowed at the end", id=12018)
    public RegistrationException invalidPath(String var1);

    @Message(value="Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'", id=12019)
    public RegistrationException duplicateResource(String var1, Invocation var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="MassIndexer started", id=12020)
    public void asyncMassIndexerStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="MassIndexer completed successfully", id=12021)
    public void asyncMassIndexerSuccess();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing MassIndexer", id=12022)
    public void errorExecutingMassIndexer(@Cause Throwable var1);
}

