/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.Health;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.stats.CacheContainerStats;

public class CacheManagerResource
implements ResourceHandler {
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;
    private final JsonWriter jsonWriter = new JsonWriter();
    private final ObjectMapper objectMapper;
    private final ParserRegistry parserRegistry = new ParserRegistry();
    private final String cacheManagerName;

    public CacheManagerResource(InvocationHelper invocationHelper) {
        this.objectMapper = invocationHelper.getMapper();
        this.cacheManager = invocationHelper.getRestCacheManager().getInstance();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.cacheManager);
        this.cacheManagerName = globalConfiguration.cacheManagerName();
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
        this.internalCacheRegistry = (InternalCacheRegistry)globalComponentRegistry.getComponent(InternalCacheRegistry.class);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.HEAD).path("/v2/cache-managers/{name}/health").handleWith(this::getHealth).invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/v2/cache-managers/{name}/health/status").handleWith(this::getHealthStatus).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/cache-configs").handleWith(this::getAllCachesConfiguration).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/cache-configs/templates").handleWith(this::getAllCachesConfigurationTemplates).invocation().methods(Method.POST).path("/v2/cache-managers/{name}/config").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/config").handleWith(this::getConfig).invocation().methods(Method.GET).path("/v2/cache-managers/{name}").handleWith(this::getInfo).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/stats").handleWith(this::getStats).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/caches").handleWith(this::getCaches).create();
    }

    private CompletionStage<RestResponse> getInfo(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)this.cacheManager.getCacheManagerInfo());
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getConfig(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        GlobalConfiguration globalConfiguration = this.cacheManager.getCacheManagerConfiguration();
        MediaType format = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parserRegistry.serialize((OutputStream)baos, globalConfiguration, Collections.emptyMap());
            if (format.match(MediaType.APPLICATION_XML)) {
                responseBuilder.contentType(MediaType.APPLICATION_XML);
                responseBuilder.entity(baos.toByteArray());
            } else {
                responseBuilder.contentType(MediaType.APPLICATION_JSON);
                responseBuilder.entity(this.jsonWriter.toJSON((ConfigurationInfo)globalConfiguration));
            }
        }
        catch (XMLStreamException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        CacheContainerStats stats = this.cacheManager.getStats();
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)stats);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getHealth(RestRequest restRequest) {
        return this.getHealth(restRequest, false);
    }

    private CompletionStage<RestResponse> getHealthStatus(RestRequest restRequest) {
        return this.getHealth(restRequest, true);
    }

    private CompletionStage<RestResponse> getHealth(RestRequest restRequest, boolean anon) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(restRequest);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        if (restRequest.method() == Method.HEAD) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.OK).build());
        }
        try {
            Health health = SecurityActions.getHealth(this.cacheManager);
            HealthInfo healthInfo = new HealthInfo(health.getClusterHealth(), health.getCacheHealth());
            MediaType contentType = anon ? MediaType.TEXT_PLAIN : MediaType.APPLICATION_JSON;
            Object payload = anon ? healthInfo.clusterHealth.getHealthStatus().toString() : (Object)this.objectMapper.writeValueAsBytes((Object)healthInfo);
            responseBuilder.contentType(contentType).entity(payload).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getCaches(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        HashMap<String, HealthStatus> cachesHeath = new HashMap<String, HealthStatus>();
        for (CacheHealth ch : SecurityActions.getHealth(this.cacheManager).getCacheHealth()) {
            cachesHeath.put(ch.getCacheName(), ch.getStatus());
        }
        return (CompletionStage)Flowable.fromIterable((Iterable)this.cacheManager.getCacheNames()).map(arg_0 -> ((EmbeddedCacheManager)this.cacheManager).getCache(arg_0)).map(cache -> {
            CacheInfo cacheInfo = new CacheInfo();
            cacheInfo.name = cache.getName();
            Configuration cacheConfiguration = cache.getCacheConfiguration();
            cacheInfo.type = cacheConfiguration.clustering().cacheMode().toCacheType();
            cacheInfo.status = cache.getStatus().name();
            cacheInfo.simpleCache = cacheConfiguration.simpleCache();
            cacheInfo.transactional = cacheConfiguration.transaction().transactionMode().isTransactional();
            cacheInfo.persistent = cacheConfiguration.persistence().usingStores();
            cacheInfo.bounded = cacheConfiguration.expiration().maxIdle() != -1L || cacheConfiguration.expiration().lifespan() != -1L;
            cacheInfo.secured = cacheConfiguration.security().authorization().enabled();
            cacheInfo.indexed = cacheConfiguration.indexing().enabled();
            cacheInfo.hasRemoteBackup = cacheConfiguration.sites().hasEnabledBackups();
            cacheInfo.health = (HealthStatus)cachesHeath.get(cache.getName());
            return cacheInfo;
        }).collectInto(new HashSet(), Set::add).map(cacheInfos -> {
            try {
                List sortedCacheInfos = cacheInfos.stream().sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
                byte[] bytes = this.objectMapper.writeValueAsBytes(sortedCacheInfos);
                responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes);
            }
            catch (JsonProcessingException e) {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return responseBuilder.build();
        }).to(RxJavaInterop.singleToCompletionStage());
    }

    private CompletionStage<RestResponse> getAllCachesConfiguration(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        try {
            Set cacheConfigurationNames = this.cacheManager.getCacheConfigurationNames();
            List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).distinct().map(n -> {
                Configuration cacheConfiguration = this.cacheManager.getCacheConfiguration(n);
                String json = this.jsonWriter.toJSON((ConfigurationInfo)cacheConfiguration);
                return new NamedCacheConfiguration((String)n, json);
            }).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
            byte[] bytes = this.objectMapper.writeValueAsBytes(configurations);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getAllCachesConfigurationTemplates(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        try {
            Set cacheConfigurationNames = this.cacheManager.getCacheConfigurationNames();
            List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).filter(n -> this.cacheManager.getCacheConfiguration(n).isTemplate()).distinct().map(n -> new NamedCacheConfiguration((String)n, this.jsonWriter.toJSON((ConfigurationInfo)this.cacheManager.getCacheConfiguration(n)))).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
            byte[] bytes = this.objectMapper.writeValueAsBytes(configurations);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(restRequest);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ContentSource contents = restRequest.contents();
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(new String(contents.rawContent(), StandardCharsets.UTF_8));
        ConfigurationBuilder builder = (ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().values().iterator().next();
        Configuration configuration = builder.build();
        responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(this.jsonWriter.toJSON((ConfigurationInfo)configuration));
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private NettyRestResponse.Builder checkCacheManager(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String name = request.variables().get("name");
        if (!name.equals(this.cacheManagerName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
        }
        return responseBuilder;
    }

    class CacheInfo {
        public String status;
        public String name;
        public String type;
        public boolean simpleCache;
        public boolean transactional;
        public boolean persistent;
        public boolean bounded;
        public boolean indexed;
        public boolean secured;
        public boolean hasRemoteBackup;
        public HealthStatus health;

        CacheInfo() {
        }
    }

    class NamedCacheConfiguration {
        String name;
        Object configuration;

        NamedCacheConfiguration(String name, Object configuration) {
            this.name = name;
            this.configuration = configuration;
        }

        public String getName() {
            return this.name;
        }

        @JsonRawValue
        public Object getConfiguration() {
            return this.configuration;
        }
    }

    class HealthInfo {
        private final ClusterHealth clusterHealth;
        private final List<CacheHealth> cacheHealth;

        HealthInfo(ClusterHealth clusterHealth, List<CacheHealth> cacheHealth) {
            this.clusterHealth = clusterHealth;
            this.cacheHealth = cacheHealth;
        }

        public ClusterHealth getClusterHealth() {
            return this.clusterHealth;
        }

        public List<CacheHealth> getCacheHealth() {
            return this.cacheHealth;
        }
    }
}

