/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.resources.BaseCacheResource;
import org.infinispan.util.concurrent.CompletableFutures;

public class ProtobufResource
extends BaseCacheResource
implements ResourceHandler {
    private final ObjectMapper objectMapper;

    public ProtobufResource(InvocationHelper invocationHelper) {
        super(invocationHelper);
        this.objectMapper = invocationHelper.getMapper();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/schemas").handleWith(this::getSchemasNames).invocation().methods(Method.POST).path("/v2/schemas/{schemaName}").handleWith(r -> this.createOrReplace((RestRequest)r, true)).invocation().methods(Method.PUT).path("/v2/schemas/{schemaName}").handleWith(r -> this.createOrReplace((RestRequest)r, false)).invocation().methods(Method.GET).path("/v2/schemas/{schemaName}").handleWith(this::getSchema).invocation().method(Method.DELETE).path("/v2/schemas/{schemaName}").handleWith(this::deleteSchema).create();
    }

    private CompletionStage<RestResponse> getSchemasNames(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        return CompletableFuture.supplyAsync(() -> Flowable.fromIterable((Iterable)cache.keySet()).filter(key -> !((String)key).endsWith(".errors")).map(key -> {
            String error = (String)cache.get((Object)(key + ".errors"));
            ProtoSchema protoSchema = new ProtoSchema();
            protoSchema.name = (String)key;
            if (error != null) {
                protoSchema.error = this.createErrorContent(protoSchema.name, error);
            }
            return protoSchema;
        }).sorted(Comparator.comparing(s -> s.name)).collect(Collectors.toList()).map(protoSchemas -> {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes(protoSchemas);
                responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes);
            }
            catch (JsonProcessingException e) {
                throw new RestResponseException(e);
            }
            return responseBuilder.build();
        }).toCompletionStage(), this.invocationHelper.getExecutor()).thenCompose(Function.identity());
    }

    private CompletionStage<RestResponse> createOrReplace(RestRequest request, boolean create) {
        String schemaName = this.checkMandatorySchemaName(request);
        ContentSource contents = request.contents();
        if (contents == null) {
            throw new NoDataFoundException("Schema data not sent in the request");
        }
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        CompletionStage putSchema = create ? cache.putIfAbsentAsync((Object)schemaName, (Object)contents.asString()).thenApply(result -> {
            if (result == null) {
                builder.status(HttpResponseStatus.CREATED);
            } else {
                builder.status(HttpResponseStatus.CONFLICT);
            }
            return result;
        }) : cache.putAsync((Object)schemaName, (Object)contents.asString()).thenApply(result -> builder.status(HttpResponseStatus.OK));
        return ((CompletableFuture)((CompletableFuture)putSchema).thenCompose(r -> {
            if (this.isOkOrCreated(builder)) {
                return cache.getAsync((Object)(schemaName + ".errors"));
            }
            return CompletableFutures.completedNull();
        })).thenApply(validationError -> {
            if (this.isOkOrCreated(builder)) {
                ProtoSchema protoSchema = new ProtoSchema();
                protoSchema.name = schemaName;
                if (validationError != null) {
                    protoSchema.error = this.createErrorContent(schemaName, (String)validationError);
                }
                byte[] detailsResponse = Util.EMPTY_BYTE_ARRAY;
                try {
                    detailsResponse = this.invocationHelper.getMapper().writeValueAsBytes((Object)protoSchema);
                }
                catch (JsonProcessingException e) {
                    builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
                return builder.contentType(MediaType.APPLICATION_JSON).entity(detailsResponse).build();
            }
            return builder.build();
        });
    }

    private boolean isOkOrCreated(NettyRestResponse.Builder builder) {
        return builder.getHttpStatus() == HttpResponseStatus.CREATED || builder.getHttpStatus() == HttpResponseStatus.OK;
    }

    private CompletionStage<RestResponse> getSchema(RestRequest request) {
        String schemaName = this.checkMandatorySchemaName(request);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        return restCacheManager.getPrivilegedInternalEntry(cache, schemaName, true).thenApply(entry -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            if (entry == null) {
                responseBuilder.status(HttpResponseStatus.NOT_FOUND.code());
            } else {
                responseBuilder.status(HttpResponseStatus.OK.code());
                responseBuilder.contentType(MediaType.TEXT_PLAIN);
                responseBuilder.entity(entry.getValue());
            }
            return responseBuilder.build();
        });
    }

    private CompletionStage<RestResponse> deleteSchema(RestRequest request) {
        String schemaName = this.checkMandatorySchemaName(request);
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> protobufCache = restCacheManager.getCache("___protobuf_metadata", request);
        return restCacheManager.getPrivilegedInternalEntry(protobufCache, schemaName, true).thenCompose(entry -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                responseBuilder.status(HttpResponseStatus.NO_CONTENT.code());
                return restCacheManager.remove("___protobuf_metadata", schemaName, MediaType.MATCH_ALL, request).thenApply(v -> responseBuilder.build());
            }
            return CompletableFuture.completedFuture(responseBuilder.build());
        });
    }

    private ValidationError createErrorContent(String schemaName, String cause) {
        String message = "Schema " + schemaName + " has errors";
        ValidationError validationError = new ValidationError();
        validationError.message = message;
        validationError.cause = cause;
        return validationError;
    }

    private String checkMandatorySchemaName(RestRequest request) {
        String schemaName = request.variables().get("schemaName");
        if (schemaName == null) {
            throw new NoKeyException("schemaName");
        }
        return schemaName.endsWith(".proto") ? schemaName : schemaName + ".proto";
    }

    static class ProtoSchema {
        public String name;
        public ValidationError error;

        ProtoSchema() {
        }
    }

    static class ValidationError {
        public String message;
        public String cause;

        ValidationError() {
        }
    }
}

