/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;

public class TasksResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;

    public TasksResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/tasks/").handleWith(this::listTasks).invocation().methods(Method.PUT, Method.POST).path("/v2/tasks/{taskName}").handleWith(this::createScriptTask).invocation().methods(Method.GET).path("/v2/tasks/{taskName}").withAction("exec").handleWith(this::runTask).create();
    }

    private CompletionStage<RestResponse> listTasks(RestRequest request) {
        String type = request.getParameter("type");
        boolean userOnly = type != null && type.equalsIgnoreCase("user");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(TaskManager.class);
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        try {
            List tasks = userOnly ? taskManager.getUserTasks() : taskManager.getTasks();
            byte[] resultBytes = this.invocationHelper.getMapper().writeValueAsBytes((Object)tasks);
            builder.contentType("application/json").entity(resultBytes);
        }
        catch (JsonProcessingException e) {
            builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> createScriptTask(RestRequest request) {
        String taskName = request.variables().get("taskName");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance().withSubject(request.getSubject());
        ScriptingManager scriptingManager = (ScriptingManager)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(ScriptingManager.class);
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        MediaType sourceType = request.contentType() == null ? MediaType.APPLICATION_JAVASCRIPT : request.contentType();
        String script = StandardConversions.convertTextToObject((Object)bytes, (MediaType)sourceType);
        Subject.doAs(request.getSubject(), () -> {
            scriptingManager.addScript(taskName, script);
            return null;
        });
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> runTask(RestRequest request) {
        String taskName = request.variables().get("taskName");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(TaskManager.class);
        TaskContext taskContext = new TaskContext();
        request.parameters().forEach((k, v) -> {
            if (k.startsWith("param.")) {
                taskContext.addParameter(k.substring(6), v.get(0));
            }
        });
        CompletionStage runResult = Subject.doAs(request.getSubject(), () -> taskManager.runTask(taskName, taskContext));
        return runResult.thenApply(result -> {
            NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
            try {
                if (result instanceof byte[]) {
                    builder.contentType("text/plain").entity(result);
                } else {
                    byte[] resultBytes = this.invocationHelper.getMapper().writeValueAsBytes(result);
                    builder.contentType("application/json").entity(resultBytes);
                }
            }
            catch (JsonProcessingException e) {
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
            }
            return builder.build();
        });
    }
}

