/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TextObjectTranscoderTest")
public class TextObjectTranscoderTest
extends AbstractTranscoderTest {
    protected Person dataSrc;

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.dataSrc = new Person("Joe");
        Address address = new Address();
        address.setCity("London");
        this.dataSrc.setAddress(address);
        this.transcoder = new DefaultTranscoder((Marshaller)TestingUtil.createProtoStreamMarshaller((SerializationContextInitializer)RestTestSCI.INSTANCE));
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    public void testTranscoderTranscode() {
        Object transcoded = this.transcoder.transcode((Object)this.dataSrc, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN);
        Assert.assertEquals((String)new String((byte[])transcoded), (String)this.dataSrc.toString());
        transcoded = this.transcoder.transcode(transcoded, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN);
        Assert.assertTrue((boolean)(transcoded instanceof byte[]), (String)"Must be byte[]");
    }
}

