/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.resources.security.AuthClient;
import org.infinispan.rest.resources.security.SimpleSecurityDomain;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AbstractRestResourceTest
extends MultipleCacheManagersTest {
    public static final String REALM = "ApplicationRealm";
    public static final Subject ADMIN_USER = TestingUtil.makeSubject((String[])new String[]{"ADMIN", "___script_manager", "___schema_manager"});
    public static final Subject USER = TestingUtil.makeSubject((String[])new String[]{"USER"});
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    protected HttpClient client;
    private static final int NUM_SERVERS = 2;
    private List<RestServerHelper> restServers = new ArrayList<RestServerHelper>(2);
    protected boolean security;

    protected String parameters() {
        return "[security=" + this.security + "]";
    }

    protected AbstractRestResourceTest withSecurity(boolean security) {
        this.security = security;
        return this;
    }

    public ConfigurationBuilder getDefaultCacheBuilder() {
        return AbstractRestResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
    }

    protected boolean isSecurityEnabled() {
        return this.security;
    }

    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalBuilder, (String)(((Object)((Object)this)).getClass().getSimpleName() + id), (MBeanServerLookup)this.mBeanServerLookup);
        globalBuilder.cacheContainer().statistics(true);
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)RestTestSCI.INSTANCE);
        if (this.isSecurityEnabled()) {
            this.addSecurity(globalBuilder);
        }
        return globalBuilder.clusteredDefault().cacheManagerName("default");
    }

    protected void addSecurity(GlobalConfigurationBuilder globalBuilder) {
        globalBuilder.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("ADMIN").permission(AuthorizationPermission.ALL).role("USER");
    }

    protected void createCacheManagers() throws Exception {
        Security.doAs((Subject)ADMIN_USER, () -> {
            for (int i = 0; i < 2; ++i) {
                GlobalConfigurationBuilder configForNode = this.getGlobalConfigForNode(i);
                this.addClusterEnabledCacheManager(new GlobalConfigurationBuilder().read(configForNode.build()), this.getDefaultCacheBuilder(), TransportFlags.minimalXsiteFlags());
            }
            this.cacheManagers.forEach(this::defineCaches);
            for (EmbeddedCacheManager cm : this.cacheManagers) {
                Set cacheNames = cm.getCacheNames();
                cacheNames.forEach(arg_0 -> ((EmbeddedCacheManager)cm).getCache(arg_0));
                cm.getClassWhiteList().addClasses(new Class[]{TestClass.class});
                this.waitForClusterToForm(cacheNames.toArray(new String[0]));
                RestServerHelper restServerHelper = new RestServerHelper(cm);
                if (this.isSecurityEnabled()) {
                    BasicAuthenticator basicAuthenticator = new BasicAuthenticator((SecurityDomain)new SimpleSecurityDomain(USER), REALM);
                    restServerHelper.withAuthenticator((Authenticator)basicAuthenticator);
                }
                restServerHelper.start(TestResourceTracker.getCurrentTestShortName() + "-" + cm.getAddress());
                this.restServers.add(restServerHelper);
            }
            return null;
        });
        this.client = this.createNewClient();
        this.client.start();
    }

    protected RestServerHelper restServer() {
        return this.restServers.get(0);
    }

    protected void defineCaches(EmbeddedCacheManager cm) {
    }

    @AfterClass
    public void afterSuite() {
        Subject.doAs(ADMIN_USER, () -> {
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restServers.forEach(RestServerHelper::stop);
            return null;
        });
    }

    @AfterMethod
    public void afterMethod() {
        Subject.doAs(ADMIN_USER, () -> {
            this.restServers.forEach(RestServerHelper::clear);
            return null;
        });
    }

    private void putInCache(String cacheName, Object key, String keyContentType, String value, String contentType) throws InterruptedException, ExecutionException, TimeoutException {
        Request request = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), cacheName, key)).content((ContentProvider)new StringContentProvider(value)).header("Content-type", contentType).method(HttpMethod.PUT);
        if (keyContentType != null) {
            request.header("Key-Content-type", keyContentType);
        }
        ContentResponse response = request.send();
        ResponseAssertion.assertThat(response).isOk();
    }

    void putInCache(String cacheName, Object key, String value, String contentType) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, null, value, contentType);
    }

    void putStringValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "text/plain; charset=utf-8");
    }

    void putJsonValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "application/json; charset=utf-8");
    }

    void putBinaryValueInCache(String cacheName, String key, byte[] value, MediaType mediaType) throws InterruptedException, ExecutionException, TimeoutException {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), cacheName, key)).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{value})).header(HttpHeader.CONTENT_TYPE, mediaType.toString()).method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    protected HttpClient createNewClient() {
        if (this.isSecurityEnabled()) {
            return new AuthClient("user", "user");
        }
        return new HttpClient();
    }
}

