/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CounterResourceTest")
public class CounterResourceTest
extends AbstractRestResourceTest {
    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cm);
        counterManager.defineCounter("weak", CounterConfiguration.builder((CounterType)CounterType.WEAK).build());
        counterManager.defineCounter("strong", CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
    }

    public Object[] factory() {
        return new Object[]{new CounterResourceTest().withSecurity(false), new CounterResourceTest().withSecurity(true)};
    }

    @Test
    public void testWeakCounterLifecycle() throws Exception {
        CounterConfiguration counterConfig = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).storage(Storage.VOLATILE).concurrencyLevel(6).build();
        this.createCounter("sample-counter", counterConfig);
        String url = String.format("http://localhost:%d/rest/v2/counters/sample-counter", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(url + "/config").accept(new String[]{"application/json"}).send();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContentAsString());
        JsonNode config = jsonNode.get("weak-counter");
        AssertJUnit.assertEquals((int)config.get("initial-value").asInt(), (int)5);
        AssertJUnit.assertEquals((String)config.get("storage").asText(), (String)"VOLATILE");
        AssertJUnit.assertEquals((int)config.get("concurrency-level").asInt(), (int)6);
        response = this.client.newRequest(url).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(url + "/config").accept(new String[]{"application/json"}).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testWeakCounterOps() throws Exception {
        String name = "weak-test";
        this.createCounter(name, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        ContentResponse response = this.callCounterOp(name, "increment", new String[0]);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 6);
        response = this.callCounterOp(name, "increment", new String[0]);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 7);
        response = this.callCounterOp(name, "decrement", new String[0]);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 6);
        response = this.callCounterOp(name, "decrement", new String[0]);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 5);
        response = this.callCounterOp(name, "add", "delta=10");
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 15);
        response = this.callCounterOp(name, "reset", new String[0]);
        ResponseAssertion.assertThat(response).hasNoContent();
        this.waitForCounterToReach(name, 5);
    }

    @Test
    public void testStrongCounterOps() throws Exception {
        String name = "strong-test";
        this.createCounter(name, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(0L).upperBound(100L).initialValue(0L).build());
        ContentResponse response = this.callCounterOp(name, "increment", new String[0]);
        ResponseAssertion.assertThat(response).hasReturnedText("1");
        response = this.callCounterOp(name, "increment", new String[0]);
        ResponseAssertion.assertThat(response).hasReturnedText("2");
        response = this.callCounterOp(name, "decrement", new String[0]);
        ResponseAssertion.assertThat(response).hasReturnedText("1");
        response = this.callCounterOp(name, "decrement", new String[0]);
        ResponseAssertion.assertThat(response).hasReturnedText("0");
        response = this.callCounterOp(name, "add", "delta=35");
        ResponseAssertion.assertThat(response).hasReturnedText("35");
        this.waitForCounterToReach(name, 35);
        response = this.callCounterOp(name, "compareAndSet", "expect=5", "update=12");
        ResponseAssertion.assertThat(response).hasReturnedText("false");
        response = this.callCounterOp(name, "compareAndSet", "expect=35", "update=50");
        ResponseAssertion.assertThat(response).hasReturnedText("true");
        this.waitForCounterToReach(name, 50);
        response = this.callCounterOp(name, "compareAndSwap", "expect=50", "update=90");
        ResponseAssertion.assertThat(response).hasReturnedText("50");
        response = this.getCounterValue(name);
        ResponseAssertion.assertThat(response).hasReturnedText("90");
    }

    @Test
    public void testCounterNames() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String name = "weak-one-%d";
        for (int i = 0; i < 5; ++i) {
            this.createCounter(String.format(name, i), CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        }
        String url = String.format("http://localhost:%d/rest/v2/counters", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = objectMapper.readTree(response.getContent());
        Collection counterNames = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0))).getCounterNames();
        AssertJUnit.assertEquals((int)counterNames.size(), (int)jsonNode.size());
        for (int i = 0; i < jsonNode.size(); ++i) {
            AssertJUnit.assertTrue((boolean)counterNames.contains(jsonNode.get(i).asText()));
        }
    }

    private void createCounter(String name, CounterConfiguration configuration) throws InterruptedException, ExecutionException, TimeoutException {
        String url = String.format("http://localhost:%d/rest/v2/counters/" + name, this.restServer().getPort());
        AbstractCounterConfiguration config = ConvertUtil.configToParsedConfig((String)name, (CounterConfiguration)configuration);
        ContentResponse response = this.client.newRequest(url).method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(new JsonWriter().toJSON((ConfigurationInfo)config))).header("Content-Type", "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
    }

    private void waitForCounterToReach(String name, int i) {
        String url = String.format("http://localhost:%d/rest/v2/counters/" + name, this.restServer().getPort());
        this.eventually(() -> {
            ContentResponse r = this.client.newRequest(url).send();
            ResponseAssertion.assertThat(r).isOk();
            long value = Long.parseLong(r.getContentAsString());
            return value == (long)i;
        });
    }

    private ContentResponse callCounterOp(String name, String op, String ... params) throws Exception {
        String urlParams = params.length == 0 ? "" : "&" + String.join((CharSequence)"&", params);
        String url = String.format("http://localhost:%d/rest/v2/counters/%s?action=%s&%s", this.restServer().getPort(), name, op, urlParams);
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        return response;
    }

    private ContentResponse getCounterValue(String name) throws Exception {
        String url = String.format("http://localhost:%d/rest/v2/counters/%s", this.restServer().getPort(), name);
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        return response;
    }
}

