/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.tasks.DummyTaskEngine;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TasksResourceTest")
public class TasksResourceTest
extends AbstractRestResourceTest {
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        GlobalComponentRegistry gcr = cm.getGlobalComponentRegistry();
        TaskManager taskManager = (TaskManager)gcr.getComponent(TaskManager.class);
        DummyTaskEngine taskEngine = new DummyTaskEngine();
        taskManager.registerTaskEngine((TaskEngine)taskEngine);
    }

    @AfterClass
    public void tearDown() {
    }

    public Object[] factory() {
        return new Object[]{new TasksResourceTest().withSecurity(false)};
    }

    @Test
    public void testTaskList() throws Exception {
        String baseURL = String.format("http://localhost:%d/rest/v2/tasks", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(baseURL).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getContent());
        System.out.println(jsonNode);
        AssertJUnit.assertEquals((int)4, (int)jsonNode.size());
        JsonNode task = jsonNode.get(0);
        AssertJUnit.assertEquals((String)"Dummy", (String)task.get("type").asText());
        AssertJUnit.assertEquals((String)"ONE_NODE", (String)task.get("execution_mode").asText());
        AssertJUnit.assertEquals((String)"DummyRole", (String)task.get("allowed_role").asText());
    }

    @Test
    public void testTaskExec() throws Exception {
        String baseURL = String.format("http://localhost:%d/rest/v2/tasks", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(baseURL + "/SUCCESSFUL_TASK?action=exec").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getContent());
        AssertJUnit.assertEquals((String)"result", (String)jsonNode.asText());
    }

    @Test
    public void testParameterizedTaskExec() throws Exception {
        String baseURL = String.format("http://localhost:%d/rest/v2/tasks", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(baseURL + "/PARAMETERIZED_TASK?action=exec&param.parameter=Hello").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getContent());
        AssertJUnit.assertEquals((String)"Hello", (String)jsonNode.asText());
    }

    @Test
    public void testFailingTaskExec() throws Exception {
        String baseURL = String.format("http://localhost:%d/rest/v2/tasks", this.restServer().getPort());
        ContentResponse response = this.client.newRequest(baseURL + "/FAILING_TASK?action=exec").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isError();
    }

    @Test
    public void testTaskUpload() throws Exception {
        String baseURL = String.format("http://localhost:%d/rest/v2/tasks", this.restServer().getPort());
        String script = Util.getResourceAsString((String)"hello.js", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ContentResponse response = this.client.newRequest(baseURL + "/hello").header("Content-type", "application/javascript").method(HttpMethod.POST).content((ContentProvider)new StringContentProvider(script)).send();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(baseURL + "/hello?action=exec&param.greetee=Friend").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getContent());
        AssertJUnit.assertEquals((String)"Hello Friend", (String)jsonNode.asText());
    }
}

