/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources.security;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;

public class AuthClient
extends HttpClient {
    private final String credentials;

    public AuthClient(String user, String pass) {
        this.credentials = Base64.getEncoder().encodeToString(String.format("%s:%s", user, pass).getBytes(StandardCharsets.UTF_8));
    }

    public Request newRequest(String host, int port) {
        return this.addAuthHeader(super.newRequest(host, port));
    }

    public Request newRequest(String uri) {
        return this.addAuthHeader(super.newRequest(uri));
    }

    public Request newRequest(URI uri) {
        return this.addAuthHeader(super.newRequest(uri));
    }

    private Request addAuthHeader(Request request) {
        request.header(HttpHeader.AUTHORIZATION, "Basic " + this.credentials);
        return request;
    }
}

