/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.logging.RestAccessLoggingHandler;

public enum ResponseWriter {
    EMPTY{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response, boolean keepAlive) {
            HttpResponse res = response.getResponse();
            HttpUtil.setContentLength((HttpMessage)res, (long)0L);
            this.accessLog.log(ctx, request, response.getResponse());
            this.handleKeepAlive(res, ctx.writeAndFlush((Object)response.getResponse()), keepAlive);
        }
    }
    ,
    FULL{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response, boolean keepAlive) {
            HttpResponse res = response.getResponse();
            ByteBuf responseContent = ((FullHttpResponse)res).content();
            Object entity = response.getEntity();
            if (entity instanceof String) {
                ByteBufUtil.writeUtf8((ByteBuf)responseContent, (CharSequence)entity.toString());
            } else if (entity instanceof byte[]) {
                responseContent.writeBytes((byte[])entity);
            }
            HttpUtil.setContentLength((HttpMessage)res, (long)responseContent.readableBytes());
            this.accessLog.log(ctx, request, response.getResponse());
            this.handleKeepAlive(res, ctx.writeAndFlush((Object)res), keepAlive);
        }
    }
    ,
    CHUNKED_FILE{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response, boolean keepAlive) {
            try {
                HttpResponse res = response.getResponse();
                File file = (File)response.getEntity();
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                HttpUtil.setContentLength((HttpMessage)res, (long)randomAccessFile.length());
                this.accessLog.log(ctx, request, response.getResponse());
                ctx.write((Object)res);
                ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(randomAccessFile, 0L, randomAccessFile.length(), 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            catch (IOException e) {
                throw new RestResponseException(e);
            }
        }
    }
    ,
    CHUNKED_STREAM{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response, boolean keepAlive) {
            HttpResponse res = response.getResponse();
            res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            InputStream inputStream = (InputStream)response.getEntity();
            this.accessLog.log(ctx, request, response.getResponse());
            ctx.write((Object)res);
            ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream(inputStream)), (ChannelPromise)ctx.newProgressivePromise());
        }
    };

    final RestAccessLoggingHandler accessLog = new RestAccessLoggingHandler();

    void handleKeepAlive(HttpResponse response, ChannelFuture future, boolean keepAlive) {
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    abstract void writeResponse(ChannelHandlerContext var1, FullHttpRequest var2, NettyRestResponse var3, boolean var4);

    static ResponseWriter forContent(Object content) {
        if (content == null) {
            return EMPTY;
        }
        if (content instanceof String || content instanceof byte[]) {
            return FULL;
        }
        if (content instanceof File) {
            return CHUNKED_FILE;
        }
        if (content instanceof InputStream) {
            return CHUNKED_STREAM;
        }
        throw new RestResponseException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Cannot write content of type " + content.getClass());
    }
}

