/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheManagerResourceTest")
public class CacheManagerResourceTest
extends AbstractRestResourceTest {
    private Configuration cache1Config;
    private Configuration cache2Config;
    private ObjectMapper mapper = new ObjectMapper();
    private JsonWriter jsonWriter = new JsonWriter();
    private Configuration templateConfig;
    private RestCacheManagerClient cacheManagerClient;
    private ControlledTimeService timeService;

    public Object[] factory() {
        return new Object[]{new CacheManagerResourceTest().withSecurity(true), new CacheManagerResourceTest().withSecurity(false)};
    }

    @Override
    protected void createCacheManagers() throws Exception {
        super.createCacheManagers();
        this.cacheManagerClient = this.client.cacheManager("default");
        this.timeService = new ControlledTimeService();
        this.cacheManagers.forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true));
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        this.cache1Config = this.getCache1Config();
        this.cache2Config = this.getCache2Config();
        ConfigurationBuilder templateConfigBuilder = new ConfigurationBuilder();
        templateConfigBuilder.template(true).clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        this.templateConfig = templateConfigBuilder.build();
        cm.defineConfiguration("cache1", this.cache1Config);
        cm.defineConfiguration("cache2", this.cache2Config);
        cm.defineConfiguration("template", this.templateConfig);
    }

    private Configuration getCache1Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return builder.build();
    }

    private Configuration getCache2Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        return builder.build();
    }

    @Test
    public void testHealth() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health());
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getBody());
        JsonNode clusterHealth = jsonNode.get("cluster_health");
        AssertJUnit.assertEquals((String)clusterHealth.get("health_status").asText(), (String)HealthStatus.FAILED.toString());
        AssertJUnit.assertEquals((int)clusterHealth.get("number_of_nodes").asInt(), (int)2);
        AssertJUnit.assertEquals((int)clusterHealth.get("node_names").size(), (int)2);
        ArrayNode cacheHealth = (ArrayNode)jsonNode.get("cache_health");
        List<String> cacheNames = this.extractCacheNames(cacheHealth);
        Assert.assertTrue((boolean)cacheNames.contains("cache1"));
        Assert.assertTrue((boolean)cacheNames.contains("cache2"));
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health(true));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testCacheConfigs() throws Exception {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.cacheConfigurations(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        ArrayNode jsonNode = (ArrayNode)this.mapper.readTree(json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.templateConfig));
        AssertJUnit.assertEquals((String)cachesAndConfig.get("cache2"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.cache2Config));
        AssertJUnit.assertEquals((String)cachesAndConfig.get("cache2"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.cache2Config));
    }

    @Test
    public void testCacheConfigsTemplates() throws Exception {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.templates(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        ArrayNode jsonNode = (ArrayNode)this.mapper.readTree(json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.templateConfig));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache1"));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache2"));
    }

    @Test
    public void testCaches() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        JsonNode jsonNode = this.mapper.readTree(json);
        List<String> names = this.asText(jsonNode.findValues("name"));
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.asText(jsonNode.findValues("status"));
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        List<String> types = this.asText(jsonNode.findValues("type"));
        Assert.assertTrue((boolean)types.contains("local-cache"));
        Assert.assertTrue((boolean)types.contains("distributed-cache"));
        List<String> simpleCaches = this.asText(jsonNode.findValues("simple_cache"));
        Assert.assertTrue((boolean)simpleCaches.contains("false"));
        List<String> transactional = this.asText(jsonNode.findValues("transactional"));
        Assert.assertTrue((boolean)transactional.contains("false"));
        List<String> persistent = this.asText(jsonNode.findValues("persistent"));
        Assert.assertTrue((boolean)persistent.contains("false"));
        List<String> bounded = this.asText(jsonNode.findValues("bounded"));
        Assert.assertTrue((boolean)bounded.contains("false"));
        List<String> secured = this.asText(jsonNode.findValues("secured"));
        Assert.assertTrue((boolean)secured.contains("false"));
        List<String> indexed = this.asText(jsonNode.findValues("indexed"));
        Assert.assertTrue((boolean)indexed.contains("false"));
        List<String> hasRemoteBackup = this.asText(jsonNode.findValues("has_remote_backup"));
        Assert.assertTrue((boolean)hasRemoteBackup.contains("false"));
        List<String> health = this.asText(jsonNode.findValues("health"));
        Assert.assertTrue((boolean)health.contains("HEALTHY"));
    }

    @Test
    public void testCachesWithIgnoreCache() throws JsonProcessingException {
        if (this.security) {
            Security.doAs((Subject)TestingUtil.makeSubject((String[])new String[]{AuthorizationPermission.ADMIN.name()}), () -> this.ignoreManager.ignoreCache("cache1"));
        } else {
            this.ignoreManager.ignoreCache("cache1");
        }
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        JsonNode jsonNode = this.mapper.readTree(json);
        List<String> names = this.asText(jsonNode.findValues("name"));
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.asText(jsonNode.findValues("status"));
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        Assert.assertTrue((boolean)status.contains("IGNORED"));
    }

    private List<String> asText(List<JsonNode> values) {
        return values.stream().map(JsonNode::asText).collect(Collectors.toList());
    }

    @Test
    public void testGetGlobalConfig() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        GlobalConfiguration globalConfiguration = embeddedCacheManager.withSubject(ADMIN_USER).getCacheManagerConfiguration();
        String globalConfigJSON = this.jsonWriter.toJSON((ConfigurationInfo)globalConfiguration);
        AssertJUnit.assertEquals((String)globalConfigJSON, (String)json);
    }

    @Test
    public void testGetGlobalConfigXML() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration("application/xml"));
        ResponseAssertion.assertThat(response).isOk();
        String xml = response.getBody();
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(xml);
        GlobalConfigurationBuilder globalConfigurationBuilder = builderHolder.getGlobalConfigurationBuilder();
        Assert.assertNotNull((Object)globalConfigurationBuilder.build());
    }

    @Test
    public void testInfo() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.info());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        JsonNode cmInfo = this.mapper.readTree(json);
        AssertJUnit.assertFalse((boolean)cmInfo.get("version").asText().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.get("cluster_members").size());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.get("cluster_members_physical_addresses").size());
        AssertJUnit.assertEquals((String)"LON-1", (String)cmInfo.get("local_site").asText());
    }

    @Test
    public void testStats() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        JsonNode cmStats = this.mapper.readTree(json);
        Assert.assertTrue((boolean)cmStats.get("statistics_enabled").asBoolean());
        AssertJUnit.assertEquals((int)0, (int)cmStats.get("stores").asInt());
        AssertJUnit.assertEquals((int)0, (int)cmStats.get("number_of_entries").asInt());
        this.timeService.advance(1000L);
        ((EmbeddedCacheManager)this.cacheManagers.iterator().next()).getCache("cache1").put((Object)"key", (Object)"value");
        cmStats = this.mapper.readTree(((RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats())).getBody());
        AssertJUnit.assertEquals((int)1, (int)cmStats.get("stores").asInt());
        AssertJUnit.assertEquals((int)1, (int)cmStats.get("number_of_entries").asInt());
    }

    private Map<String, String> cacheAndConfig(ArrayNode list) {
        HashMap<String, String> result = new HashMap<String, String>();
        list.elements().forEachRemaining(node -> result.put(node.get("name").asText(), node.get("configuration").toString()));
        return result;
    }

    private List<String> extractCacheNames(ArrayNode cacheStatuses) {
        ArrayList<String> names = new ArrayList<String>();
        cacheStatuses.elements().forEachRemaining(n -> names.add(n.get("cache_name").asText()));
        return names;
    }
}

