/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.AuthenticationTest")
public class AuthenticationTest
extends AbstractInfinispanTest {
    public static final String REALM = "ApplicationRealm";
    private static final String URL = String.format("/rest/v2/caches/%s/%s", "default", "test");
    private RestClient client;
    private RestServerHelper restServer;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        Subject user = TestingUtil.makeSubject((String[])new String[]{"test"});
        ((SecurityDomain)Mockito.doReturn((Object)user).when((Object)securityDomainMock)).authenticate((String)ArgumentMatchers.eq((Object)"test"), (String)ArgumentMatchers.eq((Object)"test"));
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, REALM);
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder configurationBuilder = new RestClientConfigurationBuilder();
        configurationBuilder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort());
        this.client = RestClient.forConfiguration((RestClientConfiguration)configurationBuilder.build());
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws IOException {
        this.restServer.clear();
        if (this.restServer != null) {
            this.restServer.stop();
            this.client.close();
        }
    }

    @Test
    public void shouldAuthenticateWhenProvidingProperCredentials() {
        Map<String, String> headers = Collections.singletonMap(HttpHeaderNames.AUTHORIZATION.toString(), "Basic " + Base64.getEncoder().encodeToString("test:test".getBytes()));
        CompletionStage response = this.client.raw().head(URL, headers);
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldRejectNotValidAuthorizationString() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HttpHeaderNames.AUTHORIZATION.toString(), "Invalid string");
        CompletionStage response = this.client.raw().get(URL, headers);
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldRejectNoAuthentication() {
        CompletionStage response = this.client.raw().get(URL);
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldAllowHealthAnonymously() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.raw().get("/rest/v2/cache-managers/DefaultCacheManager/health/status"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("HEALTHY");
    }
}

