/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.rest.resources.security.SimpleSecurityDomain;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.server.core.CacheIgnoreManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AbstractRestResourceTest
extends MultipleCacheManagersTest {
    public static final String REALM = "ApplicationRealm";
    public static final Subject ADMIN_USER = TestingUtil.makeSubject((String[])new String[]{"ADMIN", "___script_manager", "___schema_manager"});
    public static final Subject USER = TestingUtil.makeSubject((String[])new String[]{"USER", "___schema_manager"});
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    protected RestClient client;
    private static final int NUM_SERVERS = 2;
    private final List<RestServerHelper> restServers = new ArrayList<RestServerHelper>(2);
    protected boolean security;
    protected CacheIgnoreManager ignoreManager;

    protected String parameters() {
        return "[security=" + this.security + "]";
    }

    protected AbstractRestResourceTest withSecurity(boolean security) {
        this.security = security;
        return this;
    }

    public ConfigurationBuilder getDefaultCacheBuilder() {
        return AbstractRestResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
    }

    protected boolean isSecurityEnabled() {
        return this.security;
    }

    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalBuilder, (String)(((Object)((Object)this)).getClass().getSimpleName() + id), (MBeanServerLookup)this.mBeanServerLookup);
        globalBuilder.cacheContainer().statistics(true);
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)RestTestSCI.INSTANCE);
        if (this.isSecurityEnabled()) {
            this.addSecurity(globalBuilder);
        }
        return globalBuilder.clusteredDefault().cacheManagerName("default");
    }

    protected void addSecurity(GlobalConfigurationBuilder globalBuilder) {
        globalBuilder.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("ADMIN").permission(AuthorizationPermission.ALL).role("USER").permission(new AuthorizationPermission[]{AuthorizationPermission.WRITE, AuthorizationPermission.READ, AuthorizationPermission.EXEC});
    }

    protected void createCacheManagers() throws Exception {
        Security.doAs((Subject)ADMIN_USER, () -> {
            for (int i = 0; i < 2; ++i) {
                GlobalConfigurationBuilder configForNode = this.getGlobalConfigForNode(i);
                this.addClusterEnabledCacheManager(new GlobalConfigurationBuilder().read(configForNode.build()), this.getDefaultCacheBuilder(), TransportFlags.minimalXsiteFlags());
            }
            this.cacheManagers.forEach(this::defineCaches);
            this.cacheManagers.forEach(cm -> cm.defineConfiguration("invalid", this.getDefaultCacheBuilder().indexing().enabled(true).addIndexedEntities(new String[]{"invalid"}).build()));
            for (EmbeddedCacheManager cm2 : this.cacheManagers) {
                cm2.getClassWhiteList().addClasses(new Class[]{TestClass.class});
                this.waitForClusterToForm((String[])cm2.getCacheNames().stream().filter(name -> {
                    try {
                        cm2.getCache(name);
                        return true;
                    }
                    catch (CacheConfigurationException ignored) {
                        return false;
                    }
                }).toArray(String[]::new));
                RestServerHelper restServerHelper = new RestServerHelper(cm2);
                if (this.isSecurityEnabled()) {
                    BasicAuthenticator basicAuthenticator = new BasicAuthenticator((SecurityDomain)new SimpleSecurityDomain(USER), REALM);
                    restServerHelper.withAuthenticator((Authenticator)basicAuthenticator);
                }
                restServerHelper.start(TestResourceTracker.getCurrentTestShortName() + "-" + cm2.getAddress());
                this.restServers.add(restServerHelper);
            }
            this.ignoreManager = (CacheIgnoreManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0))).getComponent(CacheIgnoreManager.class);
            return null;
        });
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.getClientConfig().build());
    }

    protected RestServerHelper restServer() {
        return this.restServers.get(0);
    }

    protected void defineCaches(EmbeddedCacheManager cm) {
    }

    @AfterClass
    public void afterSuite() {
        Subject.doAs(ADMIN_USER, () -> {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restServers.forEach(RestServerHelper::stop);
            return null;
        });
    }

    @AfterMethod
    public void afterMethod() {
        Subject.doAs(ADMIN_USER, () -> {
            this.restServers.forEach(RestServerHelper::clear);
            return null;
        });
    }

    private void putInCache(String cacheName, Object key, String keyContentType, String value, String contentType) {
        String url = String.format("/rest/v2/caches/%s/%s", cacheName, key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (keyContentType != null) {
            headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), contentType);
        }
        CompletionStage response = this.client.raw().putValue(url, headers, value, contentType);
        ResponseAssertion.assertThat(response).isOk();
    }

    void putInCache(String cacheName, Object key, String value, String contentType) {
        this.putInCache(cacheName, key, null, value, contentType);
    }

    void putStringValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "text/plain; charset=utf-8");
    }

    void putJsonValueInCache(String cacheName, String key, String value) throws InterruptedException, ExecutionException, TimeoutException {
        this.putInCache(cacheName, key, value, "application/json; charset=utf-8");
    }

    void putBinaryValueInCache(String cacheName, String key, byte[] value, MediaType mediaType) {
        RestEntity restEntity = RestEntity.create((MediaType)mediaType, (byte[])value);
        CompletionStage response = this.client.cache(cacheName).put(key, restEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    protected RestClientConfigurationBuilder getClientConfig() {
        RestClientConfigurationBuilder clientConfigurationBuilder = new RestClientConfigurationBuilder();
        if (this.isSecurityEnabled()) {
            clientConfigurationBuilder.security().authentication().enable().username("user").password("user");
        }
        this.restServers.forEach(s -> clientConfigurationBuilder.addServer().host(s.getHost()).port(s.getPort()));
        return clientConfigurationBuilder;
    }
}

