/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.dataconversion.Gzip;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.resources.BaseCacheResourceTest;
import org.infinispan.rest.search.entity.Person;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheResourceTest")
public class CacheResourceTest
extends BaseCacheResourceTest {
    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        super.defineCaches(cm);
        ConfigurationBuilder object = this.getDefaultCacheBuilder();
        object.encoding().key().mediaType("text/plain");
        object.encoding().value().mediaType("application/x-java-object");
        ConfigurationBuilder legacyStorageCache = this.getDefaultCacheBuilder();
        legacyStorageCache.encoding().key().mediaType("application/x-java-object;type=java.lang.String");
        cm.defineConfiguration("objectCache", object.build());
        cm.defineConfiguration("legacy", legacyStorageCache.build());
        cm.defineConfiguration("rest", this.getDefaultCacheBuilder().build());
    }

    public Object[] factory() {
        return new Object[]{new CacheResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false), new CacheResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false), new CacheResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true), new CacheResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true)};
    }

    @Test
    public void testLegacyPredefinedCache() {
        this.putStringValueInCache("rest", "k1", "v1");
        CompletionStage response = this.client.cache("rest").get("k1");
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldReadWriteToLegacyCache() {
        this.putStringValueInCache("legacy", "test", "test");
        CompletionStage response = this.client.cache("legacy").get("test", "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        CompletionStage response = this.client.cache("objectCache").get("test", "application/json");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"" + TestClass.class.getName() + "\",\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        CompletionStage response = this.client.cache("objectCache").get("test", "application/xml");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<?xml version=\"1.0\" ?><org.infinispan.rest.TestClass><name>test</name></org.infinispan.rest.TestClass>");
    }

    @Test
    public void shouldReadAsBinaryWithPojoCache() {
        String cacheName = "pojoCache";
        String key = "test";
        TestClass value = new TestClass();
        value.setName("test");
        this.putValueInCache(cacheName, key, value);
        RestResponse response = this.get(cacheName, key, "application/octet-stream");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadTextWithPojoCache() {
        String cacheName = "pojoCache";
        String key = "k1";
        String value = "v1";
        this.putValueInCache(cacheName, key, value);
        RestResponse response = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void shouldReadByteArrayWithPojoCache() {
        AdvancedCache cache = this.restServer().getCacheManager().getCache("pojoCache").getAdvancedCache().withEncoding(IdentityEncoder.class);
        cache.put((Object)"k1", (Object)"v1".getBytes());
        CompletionStage response = this.client.cache("pojoCache").get("k1", "application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedBytes("v1".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadAsJsonWithPojoCache() {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("pojoCache", "test", testClass);
        CompletionStage response = this.client.cache("pojoCache").get("test", "application/json");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}");
    }

    @Test
    public void shouldNegotiateFromPojoCacheWithoutAccept() {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        String cacheName = "pojoCache";
        String key = "k1";
        this.putValueInCache(cacheName, key, testClass);
        RestResponse response = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(testClass.toString());
    }

    @Test
    public void shouldWriteTextContentWithPjoCache() {
        this.putStringValueInCache("pojoCache", "key1", "data");
        CompletionStage response = this.client.cache("pojoCache").get("key1", "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("data");
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
    }

    @Test
    public void shouldWriteOctetStreamToDefaultCache() {
        this.putBinaryValueInCache("default", "keyA", "<hey>ho</hey>".getBytes(), MediaType.APPLICATION_OCTET_STREAM);
        CompletionStage response = this.client.cache("default").get("keyA");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes("<hey>ho</hey>".getBytes());
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldIgnoreDisabledCaches() {
        this.putStringValueInCache("default", "K", "V");
        RestCacheClient cacheClient = this.client.cache("default");
        CompletionStage response = cacheClient.get("K");
        ResponseAssertion.assertThat(response).isOk();
        this.restServer().ignoreCache("default");
        response = cacheClient.get("K");
        ResponseAssertion.assertThat(response).isServiceUnavailable();
        this.restServer().unignoreCache("default");
        response = cacheClient.get("K");
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldDeleteExistingValueEvenWithoutMetadata() {
        this.putValueInCache("default", "test".getBytes(), "test");
        CompletionStage response = this.client.cache("default").remove("test");
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void testCORSPreflight() {
        String url = String.format("/rest/v2/caches/%s/%s", "default", "key");
        RestRawClient rawClient = this.client.raw();
        this.putValueInCache("default", "key", "value");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HttpHeaderNames.HOST.toString(), "localhost");
        headers.put(HttpHeaderNames.ORIGIN.toString(), "http://localhost:" + this.restServer().getPort());
        headers.put(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD.toString(), "GET");
        CompletionStage preFlight = rawClient.options(url, headers);
        ResponseAssertion.assertThat(preFlight).isOk();
        ResponseAssertion.assertThat(preFlight).hasNoContent();
        ResponseAssertion.assertThat(preFlight).containsAllHeaders(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString());
        ResponseAssertion.assertThat(preFlight).hasHeaderWithValues(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), (String[])RequestHeader.toArray());
    }

    @Test
    public void testCorsGET() {
        int port = this.restServer().getPort();
        this.putStringValueInCache("default", "test", "test");
        Map<String, String> headers = Collections.singletonMap(HttpHeaderNames.ORIGIN.toString(), "http://127.0.0.1:" + port);
        CompletionStage response = this.client.cache("default").get("test", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
        ResponseAssertion.assertThat(response).hasHeaderWithValues(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS.toString(), (String[])ResponseHeader.toArray());
    }

    @Test
    public void testCorsAllowedJVMProp() {
        CompletionStage response = this.client.raw().get("/rest/v2/caches", Collections.singletonMap(HttpHeaderNames.ORIGIN.toString(), "http://infinispan.org"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
    }

    @Test
    public void testCorsSameOrigin() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String scheme = this.ssl ? "https://" : "http://";
        headers.put(HttpHeaderNames.ORIGIN.toString(), scheme + "origin-host.org");
        headers.put(HttpHeaderNames.HOST.toString(), "origin-host.org");
        CompletionStage response = this.client.raw().get("/rest/v2/caches", headers);
        ResponseAssertion.assertThat(response).isOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCORSAllOrigins() throws IOException {
        RestServerHelper restServerHelper = null;
        RestClient client = null;
        try {
            RestServerConfigurationBuilder restBuilder = new RestServerConfigurationBuilder();
            restBuilder.cors().addNewRule().allowOrigins(new String[]{"*"});
            ((RestServerConfigurationBuilder)restBuilder.host("localhost")).port(0);
            restServerHelper = RestServerHelper.defaultRestServer(new String[0]);
            RestServerConfiguration build = restBuilder.build();
            restServerHelper.withConfiguration(build).start("test");
            client = restServerHelper.createClient();
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache("default").get("test", Collections.singletonMap(HttpHeaderNames.ORIGIN.toString(), "http://host.example.com:5576")));
            ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
        }
        finally {
            client.close();
            if (restServerHelper != null) {
                restServerHelper.stop();
            }
        }
    }

    @Test
    public void testIfModifiedHeaderForCache() {
        this.putStringValueInCache("expiration", "test", "test");
        RestCacheClient cacheClient = this.client.cache("expiration");
        RestResponse resp = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.get("test"));
        String dateLast = (String)((List)resp.headers().get("Last-Modified")).get(0);
        CompletionStage sameLastModAndIfModified = cacheClient.get("test", this.createHeaders(RequestHeader.IF_MODIFIED_SINCE, dateLast));
        ResponseAssertion.assertThat(sameLastModAndIfModified).isNotModified();
        this.putStringValueInCache("expiration", "test", "test-new");
        RestResponse lastmodAfterIfModified = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.get("test"));
        dateLast = (String)((List)lastmodAfterIfModified.headers().get("Last-Modified")).get(0);
        ResponseAssertion.assertThat(lastmodAfterIfModified).isOk();
        Map<String, String> header = this.createHeaders(RequestHeader.IF_MODIFIED_SINCE, this.plus1Day(dateLast));
        CompletionStage lastmodBeforeIfModified = cacheClient.get("test", header);
        ResponseAssertion.assertThat(lastmodBeforeIfModified).isNotModified();
    }

    private String plus1Day(String rfc1123Date) {
        ZonedDateTime plus = DateUtils.parseRFC1123((String)rfc1123Date).plus(1L, ChronoUnit.DAYS);
        return DateUtils.toRFC1123((long)(plus.toEpochSecond() * 1000L));
    }

    @Test
    public void testCompression() throws Exception {
        String payload = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.putStringValueInCache("default", "k", payload);
        String path = String.format("/rest/v2/caches/%s/%s", "default", "k");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.raw().get(path, Collections.singletonMap(HttpHeaderNames.ACCEPT_ENCODING.toString(), "none")));
        ResponseAssertion.assertThat(response).hasNoContentEncoding();
        ResponseAssertion.assertThat(response).hasContentLength(payload.getBytes().length);
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.raw().get(path, Collections.singletonMap(HttpHeaderNames.ACCEPT_ENCODING.toString(), "gzip")));
        ResponseAssertion.assertThat(response).hasGzipContentEncoding();
        AssertJUnit.assertEquals((String)Gzip.decompress((byte[])response.getBodyAsByteArray()), (String)payload);
    }

    @Test
    public void testReplaceExistingObject() throws Exception {
        String initialJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}";
        String changedJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test2\"}";
        RestResponse response = this.writeJsonToCache("key", initialJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.writeJsonToCache("key", changedJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("objectCache").get("key", "application/json"));
        JsonNode jsonNode = new ObjectMapper().readTree(response.getBody());
        AssertJUnit.assertEquals((String)jsonNode.get("name").asText(), (String)"test2");
    }

    private RestResponse writeJsonToCache(String key, String json, String cacheName) {
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        return (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(cacheName).put(key, restEntity));
    }

    @Test
    public void testServerDeserialization() throws Exception {
        Person value = new Person();
        byte[] jsonMarshalled = (byte[])new JsonTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON);
        byte[] xmlMarshalled = (byte[])new XMLTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_XML);
        byte[] javaMarshalled = new JavaSerializationMarshaller().objectToByteBuffer((Object)value);
        String expectError = "Class '" + value.getClass().getName() + "' blocked by deserialization white list";
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (byte[])jsonMarshalled);
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (byte[])xmlMarshalled);
        RestEntity javaEntity = RestEntity.create((MediaType)MediaType.APPLICATION_SERIALIZED_OBJECT, (byte[])javaMarshalled);
        CompletionStage jsonResponse = this.client.cache("objectCache").put("addr2", jsonEntity);
        ResponseAssertion.assertThat(jsonResponse).isError();
        ResponseAssertion.assertThat(jsonResponse).containsReturnedText(expectError);
        CompletionStage xmlResponse = this.client.cache("objectCache").put("addr3", xmlEntity);
        ResponseAssertion.assertThat(xmlResponse).isError();
        ResponseAssertion.assertThat(xmlResponse).containsReturnedText(expectError);
        CompletionStage serializationResponse = this.client.cache("objectCache").put("addr4", javaEntity);
        ResponseAssertion.assertThat(serializationResponse).isError();
        ResponseAssertion.assertThat(serializationResponse).containsReturnedText(expectError);
    }

    static {
        System.setProperty("infinispan.server.rest.cors-allow", "http://infinispan.org");
    }
}

