/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.ClientCertAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CertificateTest")
public class CertificateTest
extends AbstractInfinispanTest {
    private RestClient client;
    private RestServerHelper restServer;

    @AfterSuite
    public void afterSuite() {
        this.restServer.stop();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        this.client.close();
    }

    @Test
    public void shouldAllowProperCertificate() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)new ClientCertAuthenticator()).withKeyStore(RestServerHelper.SERVER_KEY_STORE, RestServerHelper.STORE_PASSWORD, "pkcs12").withTrustStore(RestServerHelper.SERVER_KEY_STORE, RestServerHelper.STORE_PASSWORD, "pkcs12").withClientAuth().start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder config = new RestClientConfigurationBuilder();
        config.security().ssl().enable().trustStoreFileName(RestServerHelper.CLIENT_KEY_STORE).trustStorePassword(RestServerHelper.STORE_PASSWORD).trustStoreType("pkcs12").keyStoreFileName(RestServerHelper.CLIENT_KEY_STORE).keyStorePassword(RestServerHelper.STORE_PASSWORD).keyStoreType("pkcs12").hostnameVerifier((hostname, session) -> true).addServer().host("localhost").port(this.restServer.getPort());
        this.client = RestClient.forConfiguration((RestClientConfiguration)config.build());
        CompletionStage response = this.client.raw().get("/rest/v2/caches/default/test", Collections.emptyMap());
        AssertJUnit.assertEquals((int)404, (int)((RestResponse)response.toCompletableFuture().get(10L, TimeUnit.MINUTES)).getStatus());
    }
}

