/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.rest.client.NettyTruststoreUtil;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class NettyHttpClient {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final HttpClientInitializer initializer;
    private final boolean enableSSL;
    private final String protocol;
    private final String sniName;
    private final boolean http2;
    private Channel channel;
    private AtomicInteger streamId = new AtomicInteger(1);
    private final EventLoopGroup workerGroup;
    private final Bootstrap b;
    private SslContext sslCtx;
    private volatile boolean handshake;
    private volatile boolean priorKnowledge;
    private static final int HANDSHAKE_DELAY_SECONDS = 5;

    public static NettyHttpClient forConfiguration(RestClientConfiguration configuration) {
        ServerConfiguration serverConfiguration = (ServerConfiguration)configuration.servers().iterator().next();
        String host = serverConfiguration.host();
        int port = serverConfiguration.port();
        boolean priorKnowledge = configuration.priorKnowledge();
        String protocol = configuration.protocol().equals((Object)Protocol.HTTP_11) ? "http/1.1" : "h2";
        boolean security = configuration.security().ssl().enabled();
        try {
            SslContext sslContext = NettyTruststoreUtil.createSslContext(configuration);
            String sniName = configuration.security().ssl().sniHostName();
            return new NettyHttpClient(host, port, security, priorKnowledge, protocol, sslContext, sniName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating client", e);
        }
    }

    private NettyHttpClient(String host, int port, boolean enableSSL, boolean priorKnowledge, String protocol, SslContext sslContext, String sniName) {
        this.sslCtx = sslContext;
        this.priorKnowledge = priorKnowledge;
        this.enableSSL = enableSSL;
        this.protocol = protocol;
        this.sniName = sniName;
        this.workerGroup = new NioEventLoopGroup();
        this.initializer = new HttpClientInitializer();
        this.http2 = "h2".equals(protocol);
        this.b = new Bootstrap();
        this.b.group(this.workerGroup);
        this.b.channel(NioSocketChannel.class);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.remoteAddress(host, port);
        this.b.handler((ChannelHandler)this.initializer);
        this.channel = this.b.connect().syncUninterruptibly().channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<FullHttpResponse> sendRequest(FullHttpRequest request) {
        if (!this.handshake && this.http2) {
            NettyHttpClient nettyHttpClient = this;
            synchronized (nettyHttpClient) {
                if (!this.handshake) {
                    if (!this.enableSSL) {
                        FullHttpResponse fullHttpResponse;
                        int streamId = this.streamId.getAndAdd(2);
                        CompletionStage<FullHttpResponse> response = this.sendRequestInternal(request, streamId);
                        try {
                            fullHttpResponse = response.toCompletableFuture().get(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            throw new RuntimeException("Timeout waiting for the handshake", e);
                        }
                        return CompletableFuture.completedFuture(fullHttpResponse);
                    }
                    this.initializer.settingsHandler.awaitSettings();
                    this.handshake = true;
                }
            }
        }
        return this.sendRequestInternal(request, this.streamId.getAndAdd(2));
    }

    private CompletionStage<FullHttpResponse> sendRequestInternal(FullHttpRequest request, int streamId) {
        boolean open = this.channel.isOpen();
        if (!open) {
            this.channel = this.b.connect().syncUninterruptibly().channel();
        }
        if (this.http2) {
            request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)(this.enableSSL ? "https" : "http"));
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.TEXT_PLAIN);
        HttpUtil.setContentLength((HttpMessage)request, (long)request.content().readableBytes());
        CompletableFuture<FullHttpResponse> promise = new CompletableFuture<FullHttpResponse>();
        this.initializer.responseHandler().registerRequest(streamId, promise);
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)request);
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        }));
        return promise;
    }

    public void stop() {
        this.channel.close();
        this.channel.closeFuture().syncUninterruptibly();
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
    }

    static class SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private final ChannelPromise promise;

        SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        void awaitSettings() {
            if (!this.promise.awaitUninterruptibly(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out waiting for settings");
            }
            if (!this.promise.isSuccess()) {
                throw new RuntimeException(this.promise.cause());
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings msg) {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            log.tracef("User Event Triggered: %s", evt);
            ctx.fireUserEventTriggered(evt);
        }
    }

    class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private HttpToHttp2ConnectionHandler connectionHandler;
        private ResponseHandler responseHandler;
        SettingsHandler settingsHandler;

        HttpClientInitializer() {
        }

        public void initChannel(SocketChannel ch) {
            this.settingsHandler = new SettingsHandler(ch.newPromise());
            if (NettyHttpClient.this.protocol.equals("http/1.1")) {
                this.configureHttp1(ch);
            } else if (NettyHttpClient.this.protocol.equals("h2")) {
                this.configureHttp2(ch);
            } else {
                throw new IllegalArgumentException("Unsupported protocol" + NettyHttpClient.this.protocol);
            }
        }

        private void configureHttp1(SocketChannel ch) {
            this.responseHandler = new Http11ResponseHandler();
            ChannelPipeline p = ch.pipeline();
            if (NettyHttpClient.this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{NettyHttpClient.this.sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpClientCodec()});
            p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
            p.addLast(new ChannelHandler[]{this.responseHandler});
        }

        private void configureHttp2(SocketChannel ch) {
            this.responseHandler = new Http20ResponseHandler();
            DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
            this.connectionHandler = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).build())).frameLogger(new Http2FrameLogger(LogLevel.INFO, HttpClientInitializer.class)).connection((Http2Connection)connection).build();
            if (NettyHttpClient.this.sslCtx != null) {
                this.configureSecureHttp2(ch);
            } else if (!NettyHttpClient.this.priorKnowledge) {
                this.configureSimpleHttp2(ch);
            } else {
                this.configurePriorKnowledgeHttp2(ch);
            }
        }

        private void configureSecureHttp2(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{NettyHttpClient.this.sslCtx.newHandler(ch.alloc(), NettyHttpClient.this.sniName, -1)});
            pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(""){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if ("h2".equals(protocol)) {
                        ChannelPipeline p = ctx.pipeline();
                        p.addLast(new ChannelHandler[]{HttpClientInitializer.this.connectionHandler});
                        p.addLast(new ChannelHandler[]{HttpClientInitializer.this.settingsHandler});
                        p.addLast(new ChannelHandler[]{HttpClientInitializer.this.responseHandler});
                        return;
                    }
                    ctx.close();
                    throw new IllegalStateException("unknown protocol: " + protocol);
                }
            }});
        }

        private void configureSimpleHttp2(SocketChannel ch) {
            HttpClientCodec sourceCodec = new HttpClientCodec();
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.connectionHandler);
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ch.pipeline().addLast(new ChannelHandler[]{sourceCodec, upgradeHandler, new UserEventLogger()});
            ch.pipeline().addLast(new ChannelHandler[]{this.responseHandler});
        }

        private void configurePriorKnowledgeHttp2(SocketChannel ch) {
            ch.pipeline().addLast(new ChannelHandler[]{this.connectionHandler, new UserEventLogger()});
            ch.pipeline().addLast(new ChannelHandler[]{this.responseHandler});
        }

        ResponseHandler responseHandler() {
            return this.responseHandler;
        }
    }

    static class Http11ResponseHandler
    extends ResponseHandler {
        private AtomicReference<CompletableFuture<FullHttpResponse>> futureRef = new AtomicReference();

        Http11ResponseHandler() {
        }

        @Override
        void registerRequest(int streamId, CompletableFuture<FullHttpResponse> promise) {
            this.futureRef.set(promise);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
            this.futureRef.get().complete(msg);
        }
    }

    static class Http20ResponseHandler
    extends ResponseHandler {
        private final Map<Integer, CompletableFuture<FullHttpResponse>> responseMap = new ConcurrentHashMap<Integer, CompletableFuture<FullHttpResponse>>();

        Http20ResponseHandler() {
        }

        @Override
        void registerRequest(int streamId, CompletableFuture<FullHttpResponse> promise) {
            this.responseMap.put(streamId, promise);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
            Integer streamId = msg.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                log.error((Object)("HttpResponseHandler unexpected message received: " + msg));
                return;
            }
            CompletableFuture<FullHttpResponse> future = this.responseMap.remove(streamId);
            if (future == null) {
                log.error((Object)("Message received for unknown stream id " + streamId));
            } else {
                future.complete(msg);
            }
        }
    }

    static abstract class ResponseHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        ResponseHandler() {
        }

        abstract void registerRequest(int var1, CompletableFuture<FullHttpResponse> var2);
    }
}

