/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ProtobufResourceTest")
public class ProtobufResourceTest
extends AbstractRestResourceTest {
    public Object[] factory() {
        return new Object[]{new ProtobufResourceTest().withSecurity(false), new ProtobufResourceTest().withSecurity(true)};
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() {
        Subject.doAs(ADMIN_USER, () -> {
            ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache("___protobuf_metadata").clear();
            return null;
        });
    }

    public void listSchemasWhenEmpty() throws Exception {
        CompletionStage response = this.client.schemas().names();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = new ObjectMapper().readTree(((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((int)0, (int)jsonNode.size());
    }

    @Test
    public void getNotExistingSchema() {
        CompletionStage response = this.client.schemas().get("coco");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void updateNonExistingSchema() throws Exception {
        String person = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        CompletionStage response = this.client.schemas().put("person", person);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void putAndGetWrongProtobuf() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String errorProto = Util.getResourceAsString((String)"error.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.post("error", errorProto));
        String cause = "java.lang.IllegalStateException: Syntax error in error.proto at 3:8: unexpected label: messoge";
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getBody());
        AssertJUnit.assertEquals((String)"error.proto", (String)jsonNode.get("name").asText());
        AssertJUnit.assertEquals((String)"Schema error.proto has errors", (String)jsonNode.get("error").get("message").asText());
        AssertJUnit.assertEquals((String)cause, (String)jsonNode.get("error").get("cause").asText());
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.get("error"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("error.proto");
        this.checkListProtobufEndpointUrl("error.proto", cause);
    }

    @Test
    public void crudSchema() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.post("person", personProto));
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getBody());
        Assert.assertTrue((boolean)jsonNode.get("error").isNull());
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.get("person"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("person.proto");
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.get("person.proto"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentEqualToFile("person.proto");
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.put("person", personProto));
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.delete("person"));
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.get("person"));
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void createTwiceSchema() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        CompletionStage response = schemaClient.post("person", personProto);
        ResponseAssertion.assertThat(response).isOk();
        response = schemaClient.post("person", personProto);
        ResponseAssertion.assertThat(response).isConflicted();
    }

    @Test
    public void addAndGetListOrderedByName() throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        String personProto = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        CompletionStages.join((CompletionStage)CompletionStages.allOf((CompletionStage[])new CompletionStage[]{schemaClient.post("users", personProto), schemaClient.post("people", personProto), schemaClient.post("dancers", personProto)}));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.names());
        ResponseAssertion.assertThat(response).isOk();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(response.getBody());
        AssertJUnit.assertEquals((int)3, (int)jsonNode.size());
        AssertJUnit.assertEquals((String)"dancers.proto", (String)jsonNode.get(0).get("name").asText());
        AssertJUnit.assertEquals((String)"people.proto", (String)jsonNode.get(1).get("name").asText());
        AssertJUnit.assertEquals((String)"users.proto", (String)jsonNode.get(2).get("name").asText());
    }

    private void checkListProtobufEndpointUrl(String fileName, String errorMessage) throws Exception {
        RestSchemaClient schemaClient = this.client.schemas();
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemaClient.names());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(response.getBody());
        AssertJUnit.assertEquals((int)1, (int)jsonNode.size());
        AssertJUnit.assertEquals((String)fileName, (String)jsonNode.get(0).get("name").asText());
        AssertJUnit.assertEquals((String)"Schema error.proto has errors", (String)jsonNode.get(0).get("error").get("message").asText());
        AssertJUnit.assertEquals((String)errorMessage, (String)jsonNode.get(0).get("error").get("cause").asText());
    }
}

