/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.tasks.DummyTaskEngine;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TasksResourceTest")
public class TasksResourceTest
extends AbstractRestResourceTest {
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        GlobalComponentRegistry gcr = cm.getGlobalComponentRegistry();
        TaskManager taskManager = (TaskManager)gcr.getComponent(TaskManager.class);
        DummyTaskEngine taskEngine = new DummyTaskEngine();
        taskManager.registerTaskEngine((TaskEngine)taskEngine);
    }

    @AfterClass
    public void tearDown() {
    }

    public Object[] factory() {
        return new Object[]{new TasksResourceTest().withSecurity(true), new TasksResourceTest().withSecurity(false)};
    }

    @Test
    public void testTaskList() throws Exception {
        RestTaskClient taskClient = this.client.tasks();
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)taskClient.list(RestTaskClient.ResultType.ALL));
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getBody());
        AssertJUnit.assertEquals((int)4, (int)jsonNode.size());
        JsonNode task = jsonNode.get(0);
        AssertJUnit.assertEquals((String)"Dummy", (String)task.get("type").asText());
        AssertJUnit.assertEquals((String)"ONE_NODE", (String)task.get("execution_mode").asText());
        AssertJUnit.assertEquals((String)"DummyRole", (String)task.get("allowed_role").asText());
    }

    @Test
    public void testTaskExec() throws Exception {
        RestTaskClient taskClient = this.client.tasks();
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)taskClient.exec("SUCCESSFUL_TASK"));
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(response.getBody());
        AssertJUnit.assertEquals((String)"result", (String)jsonNode.asText());
    }

    @Test
    public void testParameterizedTaskExec() throws JsonProcessingException {
        RestTaskClient taskClient = this.client.tasks();
        CompletionStage response = taskClient.exec("PARAMETERIZED_TASK", Collections.singletonMap("parameter", "Hello"));
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((String)"Hello", (String)jsonNode.asText());
    }

    @Test
    public void testFailingTaskExec() {
        RestTaskClient taskClient = this.client.tasks();
        CompletionStage response = taskClient.exec("FAILING_TASK");
        ResponseAssertion.assertThat(response).isError();
    }

    @Test
    public void testTaskUpload() throws Exception {
        SkipTestNG.skipSinceJDK((int)12);
        RestTaskClient taskClient = this.client.tasks();
        String script = Util.getResourceAsString((String)"hello.js", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestEntity scriptEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JAVASCRIPT, (String)script);
        CompletionStage response = taskClient.uploadScript("hello", scriptEntity);
        ResponseAssertion.assertThat(response).isOk();
        response = taskClient.exec("hello", Collections.singletonMap("greetee", "Friend"));
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = this.mapper.readTree(((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((String)"Hello Friend", (String)jsonNode.asText());
    }
}

