/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.rest.CorsHandler;
import org.infinispan.rest.CorsUtil;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.StreamCorrelatorHandler;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.core.ProtocolServer;

@ChannelHandler.Sharable
public class ALPNHandler
extends ApplicationProtocolNegotiationHandler {
    private static final int CROSS_ORIGIN_ALT_PORT = 9000;
    protected final RestServer restServer;
    volatile List<CorsConfig> corsRules;

    public ALPNHandler(RestServer restServer) {
        super("http/1.1");
        this.restServer = restServer;
    }

    public void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        this.configurePipeline(ctx.pipeline(), protocol);
    }

    public void configurePipeline(ChannelPipeline pipeline, String protocol) {
        if ("h2".equals(protocol) || "http/1.1".equals(protocol)) {
            this.configureHttpPipeline(pipeline);
            return;
        }
        ProtocolServer<?> protocolServer = this.getProtocolServer(protocol);
        if (protocolServer != null) {
            pipeline.addLast(new ChannelHandler[]{protocolServer.getInitializer()});
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    protected ProtocolServer<?> getProtocolServer(String protocol) {
        return null;
    }

    private void addCommonsHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor(((RestServerConfiguration)this.restServer.getConfiguration()).getCompressionLevel())});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength())});
        pipeline.addLast(new ChannelHandler[]{new StreamCorrelatorHandler()});
        pipeline.addLast(new ChannelHandler[]{new CorsHandler(this.getCorsConfigs(), true)});
        pipeline.addLast(new ChannelHandler[]{new HttpServerKeepAliveHandler()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new RestRequestHandler(this.restServer)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CorsConfig> getCorsConfigs() {
        List<CorsConfig> rules = this.corsRules;
        if (rules == null) {
            ALPNHandler aLPNHandler = this;
            synchronized (aLPNHandler) {
                rules = this.corsRules;
                if (rules == null) {
                    rules = new ArrayList<CorsConfig>();
                    rules.addAll(CorsUtil.enableAllForSystemConfig());
                    rules.addAll(CorsUtil.enableAllForLocalHost(this.restServer.getPort(), 9000));
                    rules.addAll(((RestServerConfiguration)this.restServer.getConfiguration()).getCorsRules());
                    this.corsRules = rules;
                }
            }
        }
        return this.corsRules;
    }

    protected void configureHttpPipeline(ChannelPipeline pipeline) {
        Http2MultiplexCodec multiplexCodec = Http2MultiplexCodecBuilder.forServer((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline p = channel.pipeline();
                p.addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                ALPNHandler.this.addCommonsHandlers(p);
            }
        }).initialSettings(Http2Settings.defaultSettings()).build();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(multiplexCodec);
            }
            return null;
        };
        HttpServerCodec httpCodec = new HttpServerCodec(4096, 8192, this.maxContentLength());
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpCodec, upgradeCodecFactory, this.maxContentLength());
        CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpCodec, upgradeHandler, (ChannelHandler)multiplexCodec);
        pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
        this.addCommonsHandlers(pipeline);
    }

    protected int maxContentLength() {
        return ((RestServerConfiguration)this.restServer.getConfiguration()).maxContentLength() + 4096 + 8192;
    }

    public ChannelHandler getRestHandler() {
        return new RestRequestHandler(this.restServer);
    }

    public ApplicationProtocolConfig getAlpnConfiguration() {
        if (((RestServerConfiguration)this.restServer.getConfiguration()).ssl().enabled()) {
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        }
        return null;
    }
}

