/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.StaticResourceTest")
public class StaticResourceTest
extends AbstractRestResourceTest {
    private static final Map<String, String> NO_COMPRESSION = Collections.singletonMap(HttpHeaderNames.ACCEPT_ENCODING.toString(), "none");
    private RestClient noRedirectsClient;

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        RestClientConfigurationBuilder builder = super.getClientConfig();
        builder.followRedirects(false).addServer().host(this.restServer().getHost()).port(this.restServer().getPort());
        this.noRedirectsClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    @Override
    @AfterClass
    public void afterSuite() {
        super.afterSuite();
        Util.close((AutoCloseable)this.noRedirectsClient);
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
    }

    private RestResponse call(String path) {
        RestRawClient rawClient = this.client.raw();
        return (RestResponse)CompletionStages.join((CompletionStage)rawClient.get(path, NO_COMPRESSION));
    }

    private RestResponse call(String path, String ifModifiedSince) {
        HashMap<String, String> allHeaders = new HashMap<String, String>(NO_COMPRESSION);
        allHeaders.put(RequestHeader.IF_MODIFIED_SINCE.getValue(), ifModifiedSince);
        allHeaders.putAll(NO_COMPRESSION);
        RestRawClient rawClient = this.client.raw();
        return (RestResponse)CompletionStages.join((CompletionStage)rawClient.get(path, allHeaders));
    }

    public Object[] factory() {
        return new Object[]{new StaticResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false), new StaticResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false), new StaticResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true), new StaticResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true)};
    }

    @Test
    public void testGetFile() {
        RestResponse response = this.call("/static/nonexistent.html");
        ResponseAssertion.assertThat(response).isNotFound();
        response = this.call("/static");
        this.assertResponse(response, "static-test/index.html", "<h1>Hello</h1>", MediaType.TEXT_HTML);
        response = this.call("/static/index.html");
        this.assertResponse(response, "static-test/index.html", "<h1>Hello</h1>", MediaType.TEXT_HTML);
        response = this.call("/static/xml/file.xml");
        this.assertResponse(response, "static-test/xml/file.xml", "<distributed-cache", MediaType.fromString((String)"text/xml"), MediaType.APPLICATION_XML);
        response = this.call("/static/other/text/file.txt");
        this.assertResponse(response, "static-test/other/text/file.txt", "This is a text file", MediaType.TEXT_PLAIN);
    }

    @Test
    public void testConsole() {
        RestResponse response1 = this.call("/console/page.htm");
        RestResponse response2 = this.call("/console/folder/test.css");
        RestResponse response3 = this.call("/console");
        this.assertResponse(response1, "static-test/console/page.htm", "console", MediaType.TEXT_HTML);
        this.assertResponse(response2, "static-test/console/folder/test.css", ".a", MediaType.TEXT_CSS);
        ResponseAssertion.assertThat(response2).isOk();
        this.assertResponse(response3, "static-test/console/index.html", "console", MediaType.TEXT_HTML);
        RestResponse response = this.call("/console/");
        ResponseAssertion.assertThat(response).isOk();
        response = this.call("/console/create");
        ResponseAssertion.assertThat(response).isOk();
        response = this.call("/notconsole/");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    private void assertResponse(RestResponse response, String path, String returnedText, MediaType ... possibleTypes) {
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasMediaType(possibleTypes);
        ResponseAssertion.assertThat(response).containsReturnedText(returnedText);
        this.assertCacheHeaders(path, response);
        ResponseAssertion.assertThat(response).hasValidDate();
    }

    private void assertCacheHeaders(String path, RestResponse response) {
        int expireDuration = 2678400;
        File test = StaticResourceTest.getTestFile(path);
        AssertJUnit.assertNotNull((Object)test);
        ResponseAssertion.assertThat(response).hasContentLength(test.length());
        ResponseAssertion.assertThat(response).hasLastModified(test.lastModified());
        ResponseAssertion.assertThat(response).hasCacheControlHeaders("private, max-age=" + expireDuration);
        ResponseAssertion.assertThat(response).expiresAfter(expireDuration);
    }

    @Test
    public void testCacheHeaders() {
        String path = "/static/index.html";
        long lastModified = StaticResourceTest.getTestFile("static-test/index.html").lastModified();
        RestResponse response = this.call(path, DateUtils.toRFC1123((long)lastModified));
        ResponseAssertion.assertThat(response).isNotModified();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = this.call(path, "Sun, 15 Aug 1971 15:00:00 GMT");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("<h1>Hello</h1>");
        response = this.call(path, DateUtils.toRFC1123((long)System.currentTimeMillis()));
        ResponseAssertion.assertThat(response).isNotModified();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testRedirect() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.noRedirectsClient.raw().get("/"));
        ResponseAssertion.assertThat(response).isRedirect();
        ResponseAssertion.assertThat(response).hasNoContent();
        Assert.assertEquals((String)"/console/welcome", (String)((String)((List)response.headers().get("Location")).get(0)));
    }

    private static File getTestFile(String path) {
        URL resource = StaticResourceTest.class.getClassLoader().getResource(path);
        if (resource == null) {
            return null;
        }
        try {
            Path p = Paths.get(resource.toURI());
            return p.toFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

