/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.ControlledTransport;
import org.infinispan.rest.helper.RestResponses;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="rest.XSiteResourceTest")
public class XSiteResourceTest
extends AbstractMultipleSitesTest {
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final String SFO = "SFO-3";
    private static final String CACHE_1 = "CACHE_1";
    private static final String CACHE_2 = "CACHE_2";
    private static final String CACHE_MANAGER = "default";
    private final Map<String, RestServerHelper> restServerPerSite = new HashMap<String, RestServerHelper>(2);
    private final Map<String, RestClient> clientPerSite = new HashMap<String, RestClient>(2);

    protected int defaultNumberOfSites() {
        return 3;
    }

    protected int defaultNumberOfNodes() {
        return 1;
    }

    @BeforeClass
    public void startServers() {
        this.sites.forEach(site -> {
            String siteName = site.getSiteName();
            EmbeddedCacheManager cm = (EmbeddedCacheManager)site.cacheManagers().iterator().next();
            RestServerHelper restServerHelper = new RestServerHelper(cm);
            restServerHelper.start(TestResourceTracker.getCurrentTestShortName() + "-" + cm.getAddress());
            this.restServerPerSite.put(siteName, restServerHelper);
            RestClientConfiguration clientConfig = new RestClientConfigurationBuilder().addServer().host("127.0.0.1").port(restServerHelper.getPort()).build();
            RestClient client = RestClient.forConfiguration((RestClientConfiguration)clientConfig);
            this.clientPerSite.put(siteName, client);
        });
    }

    private RestCacheClient getCacheClient(String site) {
        RestClient restClient = this.clientPerSite.get(site);
        return restClient.cache(CACHE_1);
    }

    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        GlobalConfigurationBuilder configurationBuilder = super.defaultGlobalConfigurationForSite(siteIndex);
        configurationBuilder.cacheManagerName(CACHE_MANAGER);
        return configurationBuilder;
    }

    @AfterClass(alwaysRun=true)
    public void clean() {
        this.restServerPerSite.values().forEach(RestServerHelper::stop);
        this.clientPerSite.values().forEach(cli -> {
            try {
                cli.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @AfterMethod(alwaysRun=true)
    public void cleanCache() {
        RestResponses.assertNoContent(this.getCacheClient(LON).clear());
        RestResponses.assertNoContent(this.getCacheClient(NYC).clear());
    }

    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        return XSiteResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
    }

    @Test
    public void testObtainBackupStatus() {
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, NYC));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, SFO));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(NYC, LON));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(NYC, SFO));
    }

    @Test
    public void testInvalidCache() {
        RestClient client = this.clientPerSite.get(LON);
        RestResponses.assertStatus(404, client.cache("invalid-cache").xsiteBackups());
    }

    @Test
    public void testInvalidSite() {
        RestClient client = this.clientPerSite.get(LON);
        RestCacheClient cache = client.cache(CACHE_1);
        RestResponses.assertStatus(404, cache.backupStatus("invalid-site"));
    }

    @Test
    public void testOnlineOffline() {
        this.testOnlineOffline(LON, NYC);
        this.testOnlineOffline(NYC, LON);
    }

    @Test
    public void testBackups() {
        RestCacheClient cache = this.getCacheClient(LON);
        Json status = RestResponses.jsonResponseBody(cache.xsiteBackups());
        AssertJUnit.assertEquals((String)"online", (String)status.at(NYC).asString());
    }

    @Test
    public void testPushState() {
        RestCacheClient cache = this.getCacheClient(LON);
        RestCacheClient backupCache = this.getCacheClient(NYC);
        String key = "key";
        String value = "value";
        Function<String, Integer> keyOnBackup = k -> RestResponses.responseStatus(backupCache.get(key));
        this.takeBackupOffline(LON, NYC);
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus(LON, NYC));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, SFO));
        RestResponses.assertNoContent(cache.put(key, value));
        AssertJUnit.assertEquals((int)404, (int)keyOnBackup.apply(key));
        RestResponses.assertSuccessful(cache.pushSiteState(NYC));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, NYC));
        this.eventuallyEquals("OK", () -> this.pushStateStatus(cache, NYC));
        AssertJUnit.assertEquals((int)200, (int)RestResponses.responseStatus(backupCache.get(key)));
    }

    @Test
    public void testCancelPushState() throws Exception {
        RestCacheClient cache = this.getCacheClient(LON);
        RestCacheClient backupCache = this.getCacheClient(NYC);
        this.takeBackupOffline(LON, NYC);
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus(LON, NYC));
        int entries = 50;
        IntStream.range(0, entries).forEach(i -> RestResponses.assertNoContent(cache.put(String.valueOf(i), "value")));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache));
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(backupCache));
        ControlledTransport controllerTransport = ControlledTransport.replace((Cache)this.cache(LON, 0));
        controllerTransport.blockBefore(new Class[]{XSiteStatePushCommand.class});
        RestResponses.assertSuccessful(cache.pushSiteState(NYC));
        controllerTransport.waitForCommandToBlock();
        RestResponses.assertSuccessful(cache.cancelPushState(NYC));
        controllerTransport.stopBlocking();
        Json status = RestResponses.jsonResponseBody(cache.pushStateStatus());
        AssertJUnit.assertEquals((String)"CANCELED", (String)status.at(NYC).asString());
        RestResponses.assertSuccessful(cache.clearPushStateStatus());
        status = RestResponses.jsonResponseBody(cache.pushStateStatus());
        Assert.assertTrue((boolean)status.asMap().isEmpty());
        RestResponses.assertSuccessful(cache.cancelReceiveState(NYC));
    }

    @Test
    public void testTakeOfflineConfig() {
        RestCacheClient cacheClient = this.getCacheClient(LON);
        Json takeOfflineConfig = RestResponses.jsonResponseBody(cacheClient.getXSiteTakeOfflineConfig(NYC));
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.at("after_failures").asInteger());
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.at("min_wait").asInteger());
        RestResponses.assertNoContent(cacheClient.updateXSiteTakeOfflineConfig(NYC, 5, 1000L));
        takeOfflineConfig = RestResponses.jsonResponseBody(cacheClient.getXSiteTakeOfflineConfig(NYC));
        AssertJUnit.assertEquals((int)5, (int)takeOfflineConfig.at("after_failures").asInteger());
        AssertJUnit.assertEquals((int)1000, (int)takeOfflineConfig.at("min_wait").asInteger());
    }

    @Test
    public void testInvalidInputTakeOffline() {
        RestClient restClient = this.clientPerSite.get(LON);
        String url = String.format("/rest/v2/caches/%s/x-site/backups/%s/take-offline-config", CACHE_1, NYC);
        RestResponses.assertStatus(400, restClient.raw().putValue(url, new HashMap(), "invalid", "application/json"));
    }

    @Test
    public void testGetStatusAllCaches() {
        RestClient restClient = this.clientPerSite.get(LON);
        this.assertAllSitesOnline(restClient, new String[0]);
        RestResponses.assertSuccessful(restClient.cache(CACHE_2).takeSiteOffline(NYC));
        Json json = RestResponses.jsonResponseBody(restClient.cacheManager(CACHE_MANAGER).backupStatuses());
        AssertJUnit.assertEquals((String)json.at(NYC).at("status").asString(), (String)"mixed");
        AssertJUnit.assertEquals((String)((Json)json.at(NYC).at("online").asJsonList().iterator().next()).asString(), (String)CACHE_1);
        AssertJUnit.assertEquals((String)((Json)json.at(NYC).at("offline").asJsonList().iterator().next()).asString(), (String)CACHE_2);
        RestResponses.assertSuccessful(restClient.cache(CACHE_2).bringSiteOnline(NYC));
        this.assertAllSitesOnline(restClient, new String[0]);
    }

    @Test
    public void testBringAllCachesOnlineOffline() {
        RestClient restClient = this.clientPerSite.get(LON);
        RestCacheManagerClient restCacheManagerClient = restClient.cacheManager(CACHE_MANAGER);
        RestResponses.assertSuccessful(restCacheManagerClient.takeOffline(SFO));
        Json json = RestResponses.jsonResponseBody(restCacheManagerClient.backupStatuses());
        AssertJUnit.assertEquals((String)json.at(SFO).at("status").asString(), (String)"offline");
        RestResponses.assertSuccessful(restCacheManagerClient.bringBackupOnline(SFO));
        json = RestResponses.jsonResponseBody(restCacheManagerClient.backupStatuses());
        AssertJUnit.assertEquals((String)json.at(SFO).at("status").asString(), (String)"online");
    }

    @Test
    public void testPushAllCaches() {
        RestClient restClientLon = this.clientPerSite.get(LON);
        RestClient restClientSfo = this.clientPerSite.get(SFO);
        RestCacheClient cache1Lon = restClientLon.cache(CACHE_1);
        RestCacheClient cache2Lon = restClientLon.cache(CACHE_2);
        RestCacheClient cache1Sfo = restClientSfo.cache(CACHE_1);
        RestCacheClient cache2Sfo = restClientSfo.cache(CACHE_2);
        RestResponses.assertSuccessful(restClientLon.cacheManager(CACHE_MANAGER).takeOffline(SFO));
        Json backupStatuses = RestResponses.jsonResponseBody(restClientLon.cacheManager(CACHE_MANAGER).backupStatuses());
        AssertJUnit.assertEquals((String)"offline", (String)backupStatuses.at(SFO).at("status").asString());
        int entries = 10;
        IntStream.range(0, entries).forEach(i -> {
            String key = String.valueOf(i);
            String value = "value";
            RestResponses.assertNoContent(cache1Lon.put(key, value));
            RestResponses.assertNoContent(cache2Lon.put(key, value));
        });
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(cache1Sfo));
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(cache2Sfo));
        RestResponses.assertSuccessful(restClientLon.cacheManager(CACHE_MANAGER).pushSiteState(SFO));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus(LON, SFO));
        this.eventuallyEquals("OK", () -> this.pushStateStatus(cache1Lon, SFO));
        this.eventuallyEquals("OK", () -> this.pushStateStatus(cache2Lon, SFO));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache1Sfo));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache2Sfo));
    }

    private String pushStateStatus(RestCacheClient cacheClient, String siteName) {
        Json json = RestResponses.jsonResponseBody(cacheClient.pushStateStatus());
        return json.at(siteName).asString();
    }

    @Test
    public void testCancelPushAllCaches() throws Exception {
        RestClient restClientLon = this.clientPerSite.get(LON);
        RestCacheClient cache1Lon = restClientLon.cache(CACHE_1);
        RestCacheClient cache2Lon = restClientLon.cache(CACHE_2);
        RestResponses.assertNoContent(cache1Lon.put("k1", "v1"));
        RestResponses.assertNoContent(cache2Lon.put("k2", "v2"));
        ControlledTransport controlledTransport = ControlledTransport.replace((Cache)this.cache(LON, CACHE_1, 0));
        controlledTransport.blockBefore(new Class[]{XSiteStatePushCommand.class});
        RestResponses.assertSuccessful(restClientLon.cacheManager(CACHE_MANAGER).pushSiteState(SFO));
        controlledTransport.waitForCommandToBlock();
        RestResponses.assertSuccessful(restClientLon.cacheManager(CACHE_MANAGER).cancelPushState(SFO));
        controlledTransport.stopBlocking();
        Json pushStatusCache1 = RestResponses.jsonResponseBody(cache1Lon.pushStateStatus());
        Json pushStatusCache2 = RestResponses.jsonResponseBody(cache2Lon.pushStateStatus());
        AssertJUnit.assertEquals((String)"CANCELED", (String)pushStatusCache1.at(SFO).asString());
        AssertJUnit.assertEquals((String)"CANCELED", (String)pushStatusCache2.at(SFO).asString());
    }

    private int getCacheSize(RestCacheClient cacheClient) {
        return Integer.parseInt(RestResponses.responseBody(cacheClient.size()));
    }

    private void testOnlineOffline(String site, String backup) {
        this.takeBackupOffline(site, backup);
        String siteStatus = this.getBackupStatus(site, backup);
        AssertJUnit.assertEquals((String)siteStatus, (String)"offline");
        this.bringBackupOnline(site, backup);
        siteStatus = this.getBackupStatus(site, backup);
        AssertJUnit.assertEquals((String)siteStatus, (String)"online");
    }

    private void takeBackupOffline(String site, String backup) {
        RestCacheClient client = this.getCacheClient(site);
        RestResponses.assertSuccessful(client.takeSiteOffline(backup));
    }

    private void bringBackupOnline(String site, String backup) {
        RestCacheClient client = this.getCacheClient(site);
        RestResponses.assertSuccessful(client.bringSiteOnline(backup));
    }

    private String getFirstCacheManagerAddress(String site) {
        AbstractXSiteTest.TestSite testSite = this.sites.stream().filter(t -> t.getSiteName().equals(site)).findFirst().orElse(null);
        if (testSite == null) {
            return null;
        }
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)testSite.cacheManagers().iterator().next();
        return cacheManager.getAddress().toString();
    }

    private String getBackupStatus(String site, String backup) {
        RestCacheClient cacheClient = this.getCacheClient(site);
        String cacheManagerAddress = this.getFirstCacheManagerAddress(site);
        Json json = RestResponses.jsonResponseBody(cacheClient.backupStatus(backup));
        return json.at(cacheManagerAddress).asString();
    }

    private void assertAllSitesOnline(RestClient restClient, String ... sites) {
        Json json = RestResponses.jsonResponseBody(restClient.cacheManager(CACHE_MANAGER).backupStatuses());
        Arrays.stream(sites).forEach(s -> AssertJUnit.assertEquals((String)json.at(s).at("status").asString(), (String)"online"));
    }

    protected void afterSitesCreated() {
        ConfigurationBuilder builder = this.defaultConfigurationForSite(0);
        builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.SYNC).stateTransfer().chunkSize(5);
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC).stateTransfer().chunkSize(5);
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(0), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(0), (String)CACHE_2, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(2), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(2), (String)CACHE_2, (Configuration)builder.build());
        this.site(0).waitForClusterToForm(CACHE_1);
        this.site(0).waitForClusterToForm(CACHE_2);
        this.site(2).waitForClusterToForm(CACHE_1);
        this.site(2).waitForClusterToForm(CACHE_2);
        builder = this.defaultConfigurationForSite(1);
        builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.SYNC).stateTransfer().chunkSize(5);
        builder.sites().addBackup().site(this.siteName(2)).strategy(BackupConfiguration.BackupStrategy.SYNC).stateTransfer().chunkSize(5);
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(1), (String)CACHE_1, (Configuration)builder.build());
        XSiteResourceTest.defineInSite((AbstractXSiteTest.TestSite)this.site(1), (String)CACHE_2, (Configuration)builder.build());
        this.site(1).waitForClusterToForm(CACHE_1);
        this.site(1).waitForClusterToForm(CACHE_2);
    }
}

