/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseRestSearchTest
extends MultipleCacheManagersTest {
    private static final int ENTRIES = 50;
    private static final String CACHE_NAME = "search-rest";
    private static final String PROTO_FILE_NAME = "person.proto";
    protected RestClient client;
    protected RestCacheClient cacheClient;
    private final List<RestServerHelper> restServers = new ArrayList<RestServerHelper>();

    protected int getNumNodes() {
        return 3;
    }

    protected void createCacheManagers() throws Exception {
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalCfg.serialization().addContextInitializer((SerializationContextInitializer)RestTestSCI.INSTANCE);
        ConfigurationBuilder builder = this.getConfigBuilder();
        builder.statistics().enabled(true);
        ConfigurationBuilder defaultBuilder = new ConfigurationBuilder();
        this.createClusteredCaches(this.getNumNodes(), globalCfg, defaultBuilder, this.isServerMode(), new String[]{"default"});
        this.cacheManagers.forEach(cm -> {
            RestServerHelper restServer = new RestServerHelper((EmbeddedCacheManager)cm);
            restServer.start(TestResourceTracker.getCurrentTestShortName() + "-" + cm.getAddress());
            this.restServers.add(restServer);
        });
        RestClientConfigurationBuilder clientConfigurationBuilder = new RestClientConfigurationBuilder();
        this.restServers.forEach(s -> clientConfigurationBuilder.addServer().host(s.getHost()).port(s.getPort()));
        this.client = RestClient.forConfiguration((RestClientConfiguration)clientConfigurationBuilder.build());
        this.cacheClient = this.client.cache(CACHE_NAME);
        String protoFileContents = Util.getResourceAsString((String)PROTO_FILE_NAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.registerProtobuf(protoFileContents);
        this.cacheManagers.forEach(cm -> {
            cm.defineConfiguration(CACHE_NAME, builder.build());
            cm.getCache(CACHE_NAME);
        });
    }

    protected boolean isServerMode() {
        return true;
    }

    @DataProvider(name="HttpMethodProvider")
    protected static Object[][] provideCacheMode() {
        return new Object[][]{{Method.GET}, {Method.POST}};
    }

    protected RestServerHelper pickServer() {
        return this.restServers.get(0);
    }

    protected String getPath(String cacheName) {
        return String.format("/rest/v2/caches/%s?action=search", cacheName);
    }

    protected String getPath() {
        return String.format("/rest/v2/caches/%s?action=search", CACHE_NAME);
    }

    @BeforeClass
    public void setUp() {
        this.populateData();
    }

    @AfterMethod
    protected void clearContent() {
    }

    @Test(dataProvider="HttpMethodProvider")
    public void shouldReportInvalidQueries(Method method) throws Exception {
        CompletionStage response;
        String wrongQuery = "from Whatever";
        String path = this.getPath();
        if (method == Method.POST) {
            response = this.client.raw().post(path, "{ \"query\": \"" + wrongQuery + "\"}", "application/json");
        } else {
            String getURL = path.concat("&query=").concat(URLEncoder.encode(wrongQuery, "UTF-8"));
            response = this.client.raw().get(getURL);
        }
        ResponseAssertion.assertThat(response).isBadRequest();
        String contentAsString = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        Assert.assertTrue((contentAsString.contains("Unknown entity name") || contentAsString.contains("Unknown type name") ? 1 : 0) != 0, (String)contentAsString);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void shouldReturnEmptyResults(Method method) throws Exception {
        Json query = this.query("from org.infinispan.rest.search.entity.Person p where p.name = 'nobody'", method);
        this.assertZeroHits(query);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testSimpleQuery(Method method) throws Exception {
        Json queryResult = this.query("from org.infinispan.rest.search.entity.Person p where p.surname = 'Cage'", method);
        Assert.assertEquals((int)queryResult.at("total_results").asInteger(), (int)1);
        Json hits = queryResult.at("hits");
        List jsonHits = hits.asJsonList();
        Assert.assertEquals((int)jsonHits.size(), (int)1);
        Json result = (Json)jsonHits.iterator().next();
        Json firstHit = result.at("hit");
        Assert.assertEquals((int)firstHit.at("id").asInteger(), (int)2);
        Assert.assertEquals((String)firstHit.at("name").asString(), (String)"Luke");
        Assert.assertEquals((String)firstHit.at("surname").asString(), (String)"Cage");
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testMultiResultQuery(Method method) throws Exception {
        Json results = this.query("from org.infinispan.rest.search.entity.Person p where p.id < 5 and p.gender = 'MALE'", method);
        Assert.assertEquals((int)results.at("total_results").asInteger(), (int)3);
        Json hits = results.at("hits");
        Assert.assertEquals((int)hits.asList().size(), (int)3);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testProjections(Method method) throws Exception {
        Json results = this.query("Select name, surname from org.infinispan.rest.search.entity.Person", method);
        Assert.assertEquals((int)results.at("total_results").asInteger(), (int)50);
        Json hits = results.at("hits");
        List<?> names = this.findValues(hits, "name");
        List<?> surnames = this.findValues(hits, "surname");
        List<?> streets = this.findValues(hits, "street");
        List<?> gender = this.findValues(hits, "gender");
        Assert.assertEquals((int)10, (int)names.size());
        Assert.assertEquals((int)10, (int)surnames.size());
        Assert.assertEquals((int)0, (int)streets.size());
        Assert.assertEquals((int)0, (int)gender.size());
    }

    private List<?> findValues(Json hits, String fieldName) {
        return hits.asJsonList().stream().map(j -> j.at("hit")).map(h -> h.asMap().get(fieldName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testGrouping(Method method) throws Exception {
        Json results = this.query("select p.gender, count(p.name) from org.infinispan.rest.search.entity.Person p where p.id < 5 group by p.gender order by p.gender", method);
        Assert.assertEquals((int)results.at("total_results").asInteger(), (int)2);
        Json hits = results.at("hits");
        Json males = hits.at(0);
        Assert.assertEquals((int)males.at("hit").at("name").asInteger(), (int)3);
        Json females = hits.at(1);
        Assert.assertEquals((int)females.at("hit").at("name").asInteger(), (int)1);
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testOffset(Method method) throws Exception {
        String q = "select p.name from org.infinispan.rest.search.entity.Person p where p.id < 5 order by p.name desc";
        Json results = this.query(q, method, 2, 2);
        Assert.assertEquals((int)results.at("total_results").asInteger(), (int)4);
        Json hits = results.at("hits");
        Assert.assertEquals((int)hits.asList().size(), (int)2);
        Assert.assertEquals((String)hits.at(0).at("hit").at("name").asString(), (String)"Jessica");
        Assert.assertEquals((String)hits.at(1).at("hit").at("name").asString(), (String)"Danny");
    }

    @Test(dataProvider="HttpMethodProvider")
    public void testIncompleteSearch(Method method) {
        String searchUrl = this.getPath();
        CompletionStage response = method.equals((Object)Method.POST) ? this.client.raw().post(searchUrl) : this.client.raw().get(searchUrl);
        ResponseAssertion.assertThat(response).isBadRequest();
        String contentAsString = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        Json jsonNode = Json.read((String)contentAsString);
        Assert.assertTrue((boolean)jsonNode.at("error").at("message").asString().contains("Invalid search request"));
    }

    @Test
    public void testReadDocument() {
        CompletionStage<RestResponse> response = this.get("1", "*/*");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).bodyNotEmpty();
    }

    @Test
    public void testReadDocumentFromBrowser() throws Exception {
        String mediaType = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        RestResponse fromBrowser = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.get("2", mediaType));
        ResponseAssertion.assertThat(fromBrowser).isOk();
        ResponseAssertion.assertThat(fromBrowser).hasContentType("application/json");
        Json person = Json.read((String)fromBrowser.getBody());
        Assert.assertEquals((int)person.at("id").asInteger(), (int)2);
    }

    @Test
    public void testErrorPropagation() throws Exception {
        CompletionStage<RestResponse> response = this.executeQueryRequest(Method.GET, "from org.infinispan.rest.search.entity.Person where id:1", 0, 10);
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    private int getCount() throws Exception {
        Json results = this.query("from org.infinispan.rest.search.entity.Person", Method.GET);
        return results.at("total_results").asInteger();
    }

    @Test
    public void testMassIndexing() {
        boolean indexEnabled = this.getConfigBuilder().indexing().enabled();
        CompletionStage clearResponse = this.client.cache(CACHE_NAME).clearIndex();
        if (indexEnabled) {
            ResponseAssertion.assertThat(clearResponse).isOk();
        } else {
            ResponseAssertion.assertThat(clearResponse).isBadRequest();
        }
        if (indexEnabled) {
            this.eventually(() -> this.getCount() == 0);
        }
        CompletionStage massIndexResponse = this.client.cache(CACHE_NAME).reindex();
        if (indexEnabled) {
            ResponseAssertion.assertThat(massIndexResponse).isOk();
        } else {
            ResponseAssertion.assertThat(massIndexResponse).isBadRequest();
        }
        this.eventually(() -> this.getCount() == 50);
    }

    @Test
    public void testQueryStats() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.queryStats());
        if (!this.getConfigBuilder().indexing().enabled()) {
            ResponseAssertion.assertThat(response).isBadRequest();
        } else {
            ResponseAssertion.assertThat(response).isOk();
            Json stats = Json.read((String)response.getBody());
            Assert.assertTrue((stats.at("search_query_execution_count").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("search_query_total_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("search_query_execution_max_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("search_query_execution_avg_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("object_loading_total_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("object_loading_execution_max_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("object_loading_execution_avg_time").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.at("objects_loaded_count").asLong() >= 0L ? 1 : 0) != 0);
            Assert.assertNotNull((Object)stats.at("search_query_execution_max_time_query_string").asString());
            RestResponse clearResponse = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.clearQueryStats());
            response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.queryStats());
            stats = Json.read((String)response.getBody());
            ResponseAssertion.assertThat(clearResponse).isOk();
            Assert.assertEquals((long)stats.at("search_query_execution_count").asLong(), (long)0L);
            Assert.assertEquals((long)stats.at("search_query_execution_max_time").asLong(), (long)0L);
        }
    }

    @Test
    public void testIndexStats() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheClient.indexStats());
        if (!this.getConfigBuilder().indexing().enabled()) {
            ResponseAssertion.assertThat(response).isBadRequest();
        } else {
            ResponseAssertion.assertThat(response).isOk();
        }
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.client.close();
        this.restServers.forEach(RestServerHelper::stop);
    }

    protected void populateData() {
        Json person1 = this.createPerson(1, "Jessica", "Jones", "46th St", "NY 10036", "FEMALE", 1111, 2222, 3333);
        Json person2 = this.createPerson(2, "Luke", "Cage", "Malcolm X Boulevard", "NY 11221", "MALE", 4444, 5555);
        Json person3 = this.createPerson(3, "Matthew", "Murdock", "57th St", "NY 10019", "MALE", new int[0]);
        Json person4 = this.createPerson(4, "Danny", "Randy", "Vanderbilt Av.", "NY 10017", "MALE", 2122561084);
        this.index(1, person1.toString());
        this.index(2, person2.toString());
        this.index(3, person3.toString());
        this.index(4, person4.toString());
        for (int i = 5; i <= 50; ++i) {
            String text = "Generic" + i;
            Json generic = this.createPerson(i, text, text, text, text, "MALE", 2122561084);
            this.index(i, generic.toString());
        }
        this.eventually(() -> this.getCount() == 50);
    }

    private void index(int id, String person) {
        this.write(id, person, Method.POST, MediaType.APPLICATION_JSON);
    }

    protected void put(int id, String contents) {
        this.write(id, contents, Method.PUT, MediaType.APPLICATION_JSON);
    }

    protected void write(int id, String contents, Method method, MediaType contentType) {
        StringRestEntityOkHttp entity = new StringRestEntityOkHttp(contentType, contents);
        CompletionStage response = method.equals((Object)Method.POST) ? this.client.cache(CACHE_NAME).post(String.valueOf(id), (RestEntity)entity) : this.client.cache(CACHE_NAME).put(String.valueOf(id), (RestEntity)entity);
        ResponseAssertion.assertThat(response).isOk();
    }

    protected CompletionStage<RestResponse> get(String id, String accept) {
        String path = String.format("/rest/v2/caches/%s/%s", CACHE_NAME, id);
        return this.client.raw().get(path, Collections.singletonMap(RequestHeader.ACCEPT_HEADER.getValue(), accept));
    }

    protected Json createPerson(int id, String name, String surname, String street, String postCode, String gender, int ... phoneNumbers) {
        Json person = Json.object();
        person.set("_type", (Object)"org.infinispan.rest.search.entity.Person");
        person.set("id", (Object)id);
        person.set("name", (Object)name);
        person.set("surname", (Object)surname);
        person.set("gender", (Object)gender);
        Json address = Json.object();
        if (this.needType()) {
            address.set("_type", (Object)"org.infinispan.rest.search.entity.Address");
        }
        address.set("street", (Object)street);
        address.set("postCode", (Object)postCode);
        person.set("address", address);
        Json numbers = Json.array();
        for (int phone : phoneNumbers) {
            Json number = Json.object();
            if (this.needType()) {
                number.set("_type", (Object)"org.infinispan.rest.search.entity.PhoneNumber");
            }
            number.set("number", (Object)phone);
        }
        person.set("phoneNumbers", numbers);
        return person;
    }

    protected void registerProtobuf(String protoFileContents) {
        CompletionStage response = this.client.schemas().post(PROTO_FILE_NAME, protoFileContents);
        ResponseAssertion.assertThat(response).hasNoErrors();
    }

    private void assertZeroHits(Json queryResponse) {
        Json hits = queryResponse.at("hits");
        Assert.assertEquals((int)hits.asList().size(), (int)0);
    }

    private Json query(String q, Method method) throws Exception {
        return this.query(q, method, 0, 10);
    }

    private CompletionStage<RestResponse> executeQueryRequest(Method method, String q, int offset, int maxResults) throws Exception {
        String path = this.getPath();
        if (method == Method.POST) {
            Json queryReq = Json.object();
            queryReq.set("query", (Object)q);
            queryReq.set("offset", (Object)offset);
            queryReq.set("max_results", (Object)maxResults);
            return this.client.raw().post(path, queryReq.toString(), "application/json");
        }
        String queryReq = path + "&query=" + URLEncoder.encode(q, "UTF-8") + "&offset=" + offset + "&max_results=" + maxResults;
        return this.client.raw().get(queryReq);
    }

    private Json query(String q, Method method, int offset, int maxResults) throws Exception {
        CompletionStage<RestResponse> response = this.executeQueryRequest(method, q, offset, maxResults);
        ResponseAssertion.assertThat(response).isOk();
        String contentAsString = ((RestResponse)CompletionStages.join(response)).getBody();
        return Json.read((String)contentAsString);
    }

    protected boolean needType() {
        return false;
    }

    protected abstract ConfigurationBuilder getConfigBuilder();
}

