/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheV2ResourceTest")
public class CacheV2ResourceTest
extends AbstractRestResourceTest {
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{CacheV2ResourceTest.class.getName()});

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        Cache metadataCache = cm.getCache("___protobuf_metadata");
        String proto = "/* @Indexed */ message Entity { /* @Field */ required int32 value=1; }";
        metadataCache.putIfAbsent((Object)"sample.proto", (Object)proto);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        cm.defineConfiguration("indexedCache", this.getIndexedPersistedCache().build());
    }

    public Object[] factory() {
        return new Object[]{new CacheV2ResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false), new CacheV2ResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false), new CacheV2ResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true), new CacheV2ResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true)};
    }

    private ConfigurationBuilder getIndexedPersistedCache() {
        ConfigurationBuilder builder = CacheV2ResourceTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.indexing().enable().addIndexedEntity("Entity").addProperty("directory.type", "local-heap").statistics().enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("store");
        return builder;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        super.createCacheManagers();
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, Integer.toString(id)).toString());
        return config;
    }

    @Test
    public void testCacheV2KeyOps() {
        RestCacheClient cacheClient = this.client.cache("default");
        CompletionStage response = cacheClient.post("key", "value");
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.post("key", "value");
        ResponseAssertion.assertThat(response).isConflicted();
        response = cacheClient.put("key", "value-new");
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.get("key");
        ResponseAssertion.assertThat(response).hasReturnedText("value-new");
        response = cacheClient.head("key");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = cacheClient.remove("key");
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.get("key");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testCreateCacheEncodedName() {
        this.testCreateAndUseCache("a/");
        this.testCreateAndUseCache("a/b/c");
        this.testCreateAndUseCache("a-b-c");
        this.testCreateAndUseCache("\u00e1b\\\u0107\u00e9/+-$");
        this.testCreateAndUseCache("org.infinispan.cache");
        this.testCreateAndUseCache("a%25bc");
    }

    @Test
    public void testCreateCacheEncoding() {
        String cacheName = "encoding-test";
        String json = "{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}";
        this.createCache(json, cacheName);
        String cacheConfig = this.getCacheConfig("application/json", cacheName);
        Json encoding = Json.read((String)cacheConfig).at("local-cache").at("encoding");
        Json keyMediaType = encoding.at("key").at("media-type");
        Json valueMediaType = encoding.at("value").at("media-type");
        AssertJUnit.assertEquals((String)"text/plain", (String)keyMediaType.asString());
        AssertJUnit.assertEquals((String)"text/plain", (String)valueMediaType.asString());
    }

    private void testCreateAndUseCache(String name) {
        String cacheConfig = "{\"distributed-cache\":{\"mode\":\"SYNC\"}}";
        RestCacheClient cacheClient = this.client.cache(name);
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        CompletionStage sizeResponse = cacheClient.size();
        ResponseAssertion.assertThat(sizeResponse).isOk();
        ResponseAssertion.assertThat(sizeResponse).containsReturnedText("0");
        RestResponse namesResponse = (RestResponse)CompletionStages.join((CompletionStage)this.client.caches());
        ResponseAssertion.assertThat(namesResponse).isOk();
        List names = Json.read((String)namesResponse.getBody()).asJsonList().stream().map(Json::asString).collect(Collectors.toList());
        AssertJUnit.assertTrue((boolean)names.contains(name));
        CompletionStage putResponse = cacheClient.post("key", "value");
        ResponseAssertion.assertThat(putResponse).isOk();
        CompletionStage getResponse = cacheClient.get("key");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).containsReturnedText("value");
    }

    @Test
    public void testCacheV2LifeCycle() throws Exception {
        String xml = Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        String json = Util.getResourceAsString((String)"cache.json", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache("cache1").createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache1", false);
        response = this.client.cache("cache2").createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache2", true);
        String mediaList = "application/json,text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        response = this.client.cache("cache1").configuration(mediaList);
        ResponseAssertion.assertThat(response).isOk();
        String cache1Cfg = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        response = this.client.cache("cache2").configuration();
        ResponseAssertion.assertThat(response).isOk();
        String cache2Cfg = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        AssertJUnit.assertEquals((String)cache1Cfg, (String)cache2Cfg);
    }

    @Test
    public void testCreateDeleteCache() throws Exception {
        String xml = Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestCacheClient cacheClient = this.client.cache("cacheCRUD");
        CompletionStage response = cacheClient.createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.delete();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    private void assertPersistence(String name, boolean persisted) {
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache configCache = cm.getCache("org.infinispan.CONFIG");
        AssertJUnit.assertEquals((boolean)persisted, (boolean)configCache.entrySet().stream().anyMatch((SerializablePredicate & Serializable)e -> ((ScopedState)e.getKey()).getName().equals(name) && !((CacheState)e.getValue()).getFlags().contains(CacheContainerAdmin.AdminFlag.VOLATILE)));
    }

    @Test
    public void testCacheV2Stats() throws Exception {
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true } }";
        RestCacheClient cacheClient = this.client.cache("statCache");
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheJson);
        CompletionStage response = cacheClient.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.putStringValueInCache("statCache", "key1", "data");
        this.putStringValueInCache("statCache", "key2", "data");
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((int)jsonNode.at("current_number_of_entries").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)jsonNode.at("stores").asInteger(), (int)2);
        response = cacheClient.clear();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((int)Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody()).at("current_number_of_entries").asInteger(), (int)0);
    }

    @Test
    public void testCacheSize() {
        for (int i = 0; i < 100; ++i) {
            this.putInCache("default", i, "" + i, "application/json");
        }
        CompletionStage response = this.client.cache("default").size();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("100");
    }

    @Test
    public void testCacheFullDetail() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").details());
        String body = response.getBody();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"stats"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"size"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"configuration"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"rehash_in_progress"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"persistent"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"bounded"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"indexed"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"has_remote_backup"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"secured"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"indexing_in_progress"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"queryable"});
    }

    public void testCacheQueryable() {
        this.createCache(new ConfigurationBuilder(), "cacheNotQueryable");
        Json details = this.getCacheDetail("cacheNotQueryable");
        AssertJUnit.assertFalse((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().addProperty("directory.type", "local-heap").enable();
        builder.indexing().enable();
        this.createCache(builder, "cacheIndexed");
        details = this.getCacheDetail("cacheIndexed");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder proto = new ConfigurationBuilder();
        proto.encoding().mediaType("application/x-protostream");
        this.createCache(proto, "cacheQueryable");
        details = this.getCacheDetail("cacheQueryable");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
    }

    private void createCache(ConfigurationBuilder builder, String name) {
        String json = new JsonWriter().toJSON((ConfigurationInfo)builder.build());
        this.createCache(json, name);
    }

    private void createCache(String json, String name) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache(name).createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
    }

    private Json getCacheDetail(String name) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).details());
        ResponseAssertion.assertThat(response).isOk();
        return Json.read((String)response.getBody());
    }

    @Test
    public void testCacheNames() {
        CompletionStage response = this.client.caches();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        Set cacheNames = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheNames();
        int size = jsonNode.asList().size();
        AssertJUnit.assertEquals((int)cacheNames.size(), (int)size);
        for (int i = 0; i < size; ++i) {
            AssertJUnit.assertTrue((boolean)cacheNames.contains(jsonNode.at(i).asString()));
        }
    }

    @Test
    public void testFlags() {
        String proto = "/* @Indexed */ message Entity { /* @Field */ required int32 value=1; }";
        this.registerSchema("sample.proto", proto);
        RestResponse response = this.insertEntity(1, 1000, new String[0]);
        System.out.println(response.getBody());
        ResponseAssertion.assertThat(response).isOk();
        this.assertIndexed(1000);
        response = this.insertEntity(2, 1200, Flag.SKIP_INDEXING.toString(), Flag.SKIP_CACHE_LOAD.toString());
        ResponseAssertion.assertThat(response).isOk();
        this.assertNotIndexed(1200);
        response = this.insertEntity(3, 1200, "Invalid");
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testValidateCacheQueryable() {
        this.registerSchema("simple.proto", "message Simple { required int32 value=1;}");
        this.correctReportNotQueryableCache("jsonCache", new ConfigurationBuilder().encoding().mediaType("application/json").build());
    }

    private void correctReportNotQueryableCache(String name, Configuration configuration) {
        this.createAndWriteToCache(name, configuration);
        RestResponse response = this.queryCache(name);
        ResponseAssertion.assertThat(response).isBadRequest();
        Json json = Json.read((String)response.getBody());
        AssertJUnit.assertTrue((boolean)json.at("error").at("cause").toString().matches(".*ISPN028015.*"));
    }

    private RestResponse queryCache(String name) {
        return (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).query("FROM Simple"));
    }

    private void createAndWriteToCache(String name, Configuration configuration) {
        String jsonConfig = new JsonWriter().toJSON((ConfigurationInfo)configuration);
        RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)jsonConfig);
        CompletionStage response = this.client.cache(name).createWithConfiguration(configEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        RestEntity valueEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)"{\"_type\":\"Simple\",\"value\":1}");
        response = this.client.cache(name).post("1", valueEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testGetAllKeys() throws Exception {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        List emptyKeys = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyKeys.size());
        this.putStringValueInCache("default", "1", "value");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        List singleSet = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        int entries = 1000;
        for (int i = 0; i < entries; ++i) {
            this.putStringValueInCache("default", String.valueOf(i), "value");
        }
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        Set keys = Json.read((String)response.getBody()).asJsonList().stream().map(Json::asInteger).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)entries, (int)keys.size());
        AssertJUnit.assertTrue((boolean)IntStream.range(0, entries).allMatch(keys::contains));
    }

    @Test
    public void testProtobufMetadataManipulation() throws Exception {
        String cache = "___protobuf_metadata";
        this.putStringValueInCache(cache, "file1.proto", "message A{}");
        this.putStringValueInCache(cache, "file2.proto", "message B{}");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("___protobuf_metadata").keys());
        String contentAsString = response.getBody();
        List keys = Json.read((String)contentAsString).asJsonList();
        AssertJUnit.assertEquals((int)2, (int)keys.size());
    }

    @Test
    public void testGetProtoCacheConfig() {
        this.testGetProtoCacheConfig("application/xml");
        this.testGetProtoCacheConfig("application/json");
    }

    private void testGetProtoCacheConfig(String accept) {
        this.getCacheConfig(accept, "___protobuf_metadata");
    }

    private String getCacheConfig(String accept, String name) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).configuration(accept));
        ResponseAssertion.assertThat(response).isOk();
        return response.getBody();
    }

    @Test
    public void testJSONConversion() {
        RestRawClient rawClient = this.client.raw();
        String xml = "<infinispan>\n    <cache-container>\n        <distributed-cache name=\"cacheName\" mode=\"SYNC\">\n            <memory>\n                <object size=\"20\"/>\n            </memory>\n        </distributed-cache>\n    </cache-container>\n</infinispan>";
        CompletionStage response = rawClient.post("/rest/v2/caches?action=toJSON", xml, "application/xml");
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        Json distCache = jsonNode.at("distributed-cache");
        Json memory = distCache.at("memory");
        AssertJUnit.assertEquals((String)"SYNC", (String)distCache.at("mode").asString());
        AssertJUnit.assertEquals((int)20, (int)memory.at("max-count").asInteger());
    }

    @Test
    public void testCacheExists() {
        AssertJUnit.assertEquals((int)404, (int)this.checkCache("invalid"));
        AssertJUnit.assertEquals((int)200, (int)this.checkCache("default"));
        AssertJUnit.assertEquals((int)200, (int)this.checkCache("indexedCache"));
    }

    private int checkCache(String name) {
        CompletionStage response = this.client.cache(name).exists();
        return ((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus();
    }

    private void registerSchema(String name, String schema) {
        CompletionStage response = this.client.schemas().put(name, schema);
        ResponseAssertion.assertThat(response).isOk();
    }

    private RestResponse insertEntity(int key, int value, String ... flags) {
        String json = String.format("{\"_type\": \"Entity\",\"value\": %d}", value);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        return (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put(String.valueOf(key), restEntity, flags));
    }

    private void assertIndexed(int value) {
        this.assertIndex(value, true);
    }

    private void assertNotIndexed(int value) {
        this.assertIndex(value, false);
    }

    private void assertIndex(int value, boolean present) {
        String query = "FROM Entity WHERE value = " + value;
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("indexedCache").query(query));
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((boolean)present, (boolean)response.getBody().contains(String.valueOf(value)));
    }
}

