/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.BackupManagerResource;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.server.core.BackupManager;
import org.infinispan.util.function.TriConsumer;

public class ClusterResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final BackupManager backupManager;

    public ClusterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.backupManager = invocationHelper.getServer().getBackupManager();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/cluster").withAction("stop").handleWith(this::stop).invocation().methods(Method.GET).path("/v2/cluster/backups").handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.POST).path("/v2/cluster/backups/{backupName}").handleWith(this::backup).invocation().methods(Method.POST).path("/v2/cluster/backups").withAction("restore").handleWith(this::restore).create();
    }

    private CompletionStage<RestResponse> stop(RestRequest restRequest) {
        List<String> servers = restRequest.parameters().get("server");
        if (servers != null && !servers.isEmpty()) {
            this.invocationHelper.getServer().serverStop(servers);
        } else {
            this.invocationHelper.getServer().clusterStop();
        }
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT).build());
    }

    private CompletionStage<RestResponse> getAllBackupNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = backupManager.getBackupNames();
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)names));
    }

    private CompletionStage<RestResponse> backup(RestRequest request) {
        return BackupManagerResource.handleBackupRequest(request, this.backupManager, (TriConsumer<String, Path, Json>)((TriConsumer)(name, workingDir, json) -> this.backupManager.create(name, workingDir)));
    }

    private CompletionStage<RestResponse> restore(RestRequest request) {
        return BackupManagerResource.handleRestoreRequest(request, (path, json) -> this.backupManager.restore(path));
    }
}

