/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.cachemanager.SecurityActions;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.logging.Log;
import org.infinispan.security.Security;
import org.infinispan.server.core.CacheInfo;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

public class RestCacheManager<V> {
    protected static final Log logger = (Log)LogFactory.getLog(RestCacheManager.class, Log.class);
    private final EmbeddedCacheManager instance;
    private final InternalCacheRegistry icr;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private final Map<String, CacheInfo<Object, V>> knownCaches = new ConcurrentHashMap<String, CacheInfo<Object, V>>(4, 0.9f, 16);
    private final RemoveCacheListener removeCacheListener;

    public RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(instance).getComponent(InternalCacheRegistry.class);
        this.allowInternalCacheAccess = SecurityActions.getCacheManagerConfiguration(instance).security().authorization().enabled();
        this.removeCacheListener = new RemoveCacheListener();
        SecurityActions.addListener(instance, this.removeCacheListener);
    }

    public AdvancedCache<Object, V> getCache(String name, MediaType keyContentType, MediaType valueContentType, RestRequest request) {
        AdvancedCache cache;
        Subject subject = request.getSubject();
        Flag[] flags = request.getFlags();
        if (this.isCacheIgnored.test(name)) {
            throw logger.cacheUnavailable(name);
        }
        if (keyContentType == null || valueContentType == null) {
            throw logger.missingRequiredMediaType(name);
        }
        this.checkCacheAvailable(name);
        CacheInfo cacheInfo = this.knownCaches.get(name);
        if (cacheInfo == null) {
            cache = this.instance.getCache(name).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
            cacheInfo = new CacheInfo(cache);
            this.knownCaches.putIfAbsent(name, cacheInfo);
        }
        cache = cacheInfo.getCache(new KeyValuePair((Object)keyContentType, (Object)valueContentType), subject);
        if (flags != null && flags.length > 0) {
            cache = cache.withFlags(flags);
        }
        return cache;
    }

    public AdvancedCache<Object, V> getCache(String name, RestRequest restRequest) {
        return this.getCache(name, MediaType.MATCH_ALL, MediaType.MATCH_ALL, restRequest);
    }

    public boolean cacheExists(String name) {
        return this.instance.cacheExists(name);
    }

    private void checkCacheAvailable(String cacheName) {
        if (!this.instance.getCacheNames().contains(cacheName)) {
            throw logger.cacheNotFound(cacheName);
        }
        if (this.icr.isPrivateCache(cacheName)) {
            throw logger.requestNotAllowedToInternalCaches(cacheName);
        }
        if (!this.allowInternalCacheAccess && this.icr.isInternalCache(cacheName) && !this.icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.USER)) {
            throw logger.requestNotAllowedToInternalCachesWithoutAuthz(cacheName);
        }
    }

    public boolean isCacheQueryable(Cache<?, ?> cache) {
        return ((StorageConfigurationManager)SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache()).getComponent(StorageConfigurationManager.class)).isQueryable();
    }

    public Collection<String> getCacheNames() {
        return this.instance.getCacheNames();
    }

    public CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, MediaType keyContentType, MediaType mediaType, RestRequest request) {
        return this.getInternalEntry(cacheName, key, false, keyContentType, mediaType, request);
    }

    public CompletionStage<V> remove(String cacheName, Object key, MediaType keyContentType, RestRequest restRequest) {
        AdvancedCache<Object, V> cache = this.getCache(cacheName, keyContentType, MediaType.MATCH_ALL, restRequest);
        return cache.removeAsync(key);
    }

    public CompletionStage<CacheEntry<Object, V>> getPrivilegedInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        AdvancedCache cacheSkip = skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION) : cache;
        return SecurityActions.getCacheEntryAsync(cacheSkip, key);
    }

    private CompletionStage<CacheEntry<Object, V>> getInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        return skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync(key) : cache.getCacheEntryAsync(key);
    }

    public MediaType getValueConfiguredFormat(String cacheName, RestRequest restRequest) {
        return SecurityActions.getCacheConfiguration(this.getCache(cacheName, restRequest)).encoding().valueDataType().mediaType();
    }

    private CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, boolean skipListener, MediaType keyContentType, MediaType mediaType, RestRequest restRequest) {
        return this.getInternalEntry(this.getCache(cacheName, keyContentType, mediaType, restRequest), key, skipListener);
    }

    public String getNodeName() {
        Address addressToBeReturned = this.instance.getAddress();
        if (addressToBeReturned == null) {
            return "0.0.0.0";
        }
        return addressToBeReturned.toString();
    }

    public String getServerAddress() {
        Transport transport = this.instance.getTransport();
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return "0.0.0.0";
    }

    public String getPrimaryOwner(String cacheName, Object key, RestRequest restRequest) {
        DistributionManager dm = SecurityActions.getDistributionManager(this.getCache(cacheName, restRequest));
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).primary().toString();
    }

    public String getBackupOwners(String cacheName, Object key, RestRequest restRequest) {
        DistributionManager dm = SecurityActions.getDistributionManager(this.getCache(cacheName, restRequest));
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).writeBackups().stream().map(a -> a.toString()).collect(Collectors.joining(" "));
    }

    public EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    public EmbeddedCacheManagerAdmin getCacheManagerAdmin(RestRequest restRequest) {
        Subject subject = restRequest.getSubject();
        if (subject == null) {
            return this.instance.administration();
        }
        return (EmbeddedCacheManagerAdmin)Security.doAs((Subject)subject, () -> this.instance.administration().withSubject(subject));
    }

    public void stop() {
        if (this.removeCacheListener != null) {
            SecurityActions.removeListener((Listenable)this.instance, this.removeCacheListener);
        }
    }

    @Listener
    class RemoveCacheListener {
        RemoveCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            RestCacheManager.this.knownCaches.remove(event.getCacheName());
        }
    }
}

