/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.RestResponse;

class ResourceUtil {
    ResourceUtil() {
    }

    static RestResponse response(HttpResponseStatus status) {
        return ResourceUtil.response(status, null);
    }

    static RestResponse response(HttpResponseStatus status, Object entity) {
        return new NettyRestResponse.Builder().status(status).entity(entity).build();
    }

    static CompletableFuture<RestResponse> responseFuture(HttpResponseStatus status) {
        return ResourceUtil.responseFuture(status, null);
    }

    static CompletableFuture<RestResponse> responseFuture(HttpResponseStatus status, Object entity) {
        return CompletableFuture.completedFuture(ResourceUtil.response(status, entity));
    }

    static CompletableFuture<RestResponse> notFoundResponseFuture() {
        return ResourceUtil.responseFuture(HttpResponseStatus.NOT_FOUND);
    }

    static NettyRestResponse.Builder addEntityAsJson(Json json, NettyRestResponse.Builder responseBuilder) {
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        return responseBuilder.entity(json.toString()).status(HttpResponseStatus.OK);
    }

    static RestResponse asJsonResponse(Json json) {
        return ResourceUtil.addEntityAsJson(json, new NettyRestResponse.Builder()).build();
    }

    static CompletableFuture<RestResponse> asJsonResponseFuture(Json json) {
        return CompletableFuture.completedFuture(ResourceUtil.asJsonResponse(json));
    }

    static CompletableFuture<RestResponse> asJsonResponseFuture(Json json, NettyRestResponse.Builder responseBuilder) {
        NettyRestResponse response = ResourceUtil.addEntityAsJson(json, responseBuilder).build();
        return CompletableFuture.completedFuture(response);
    }

    static NettyRestResponse.Builder addEntityAsJson(JsonSerialization o, NettyRestResponse.Builder responseBuilder) {
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        return responseBuilder.entity(o.toJson().toString()).status(HttpResponseStatus.OK);
    }
}

