/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheManagerResourceTest")
public class CacheManagerResourceTest
extends AbstractRestResourceTest {
    private Configuration cache2Config;
    private final JsonWriter jsonWriter = new JsonWriter();
    private Configuration templateConfig;
    private RestCacheManagerClient cacheManagerClient;

    public Object[] factory() {
        return new Object[]{new CacheManagerResourceTest().withSecurity(true), new CacheManagerResourceTest().withSecurity(false)};
    }

    @Override
    protected void createCacheManagers() throws Exception {
        super.createCacheManagers();
        this.cacheManagerClient = this.client.cacheManager("default");
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        Configuration cache1Config = this.getCache1Config();
        this.cache2Config = this.getCache2Config();
        ConfigurationBuilder templateConfigBuilder = new ConfigurationBuilder();
        templateConfigBuilder.template(true).clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        this.templateConfig = templateConfigBuilder.build();
        cm.defineConfiguration("cache1", cache1Config);
        cm.defineConfiguration("cache2", this.cache2Config);
        cm.defineConfiguration("template", this.templateConfig);
    }

    private Configuration getCache1Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return builder.build();
    }

    private Configuration getCache2Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        return builder.build();
    }

    @Test
    public void testHealth() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.getBody());
        Json clusterHealth = jsonNode.at("cluster_health");
        AssertJUnit.assertEquals((String)clusterHealth.at("health_status").asString(), (String)HealthStatus.FAILED.toString());
        AssertJUnit.assertEquals((int)clusterHealth.at("number_of_nodes").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)clusterHealth.at("node_names").asJsonList().size(), (int)2);
        Json cacheHealth = jsonNode.at("cache_health");
        List<String> cacheNames = this.extractCacheNames(cacheHealth);
        Assert.assertTrue((boolean)cacheNames.contains("cache1"));
        Assert.assertTrue((boolean)cacheNames.contains("cache2"));
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health(true));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testCacheConfigs() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.cacheConfigurations(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.templateConfig));
        AssertJUnit.assertEquals((String)cachesAndConfig.get("cache2"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.cache2Config));
        AssertJUnit.assertEquals((String)cachesAndConfig.get("cache2"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.cache2Config));
    }

    @Test
    public void testCacheConfigsTemplates() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.templates(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)this.jsonWriter.toJSON((ConfigurationInfo)this.templateConfig));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache1"));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache2"));
    }

    @Test
    public void testCaches() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        List<String> names = this.find(jsonNode, "name");
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.find(jsonNode, "status");
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        List<String> types = this.find(jsonNode, "type");
        Assert.assertTrue((boolean)types.contains("local-cache"));
        Assert.assertTrue((boolean)types.contains("distributed-cache"));
        List<String> simpleCaches = this.find(jsonNode, "simple_cache");
        Assert.assertTrue((boolean)simpleCaches.contains("false"));
        List<String> transactional = this.find(jsonNode, "transactional");
        Assert.assertTrue((boolean)transactional.contains("false"));
        List<String> persistent = this.find(jsonNode, "persistent");
        Assert.assertTrue((boolean)persistent.contains("false"));
        List<String> bounded = this.find(jsonNode, "bounded");
        Assert.assertTrue((boolean)bounded.contains("false"));
        List<String> secured = this.find(jsonNode, "secured");
        Assert.assertTrue((boolean)secured.contains("false"));
        List<String> indexed = this.find(jsonNode, "indexed");
        Assert.assertTrue((boolean)indexed.contains("false"));
        List<String> hasRemoteBackup = this.find(jsonNode, "has_remote_backup");
        Assert.assertTrue((boolean)hasRemoteBackup.contains("false"));
        List<String> health = this.find(jsonNode, "health");
        Assert.assertTrue((boolean)health.contains("HEALTHY"));
    }

    @Test
    public void testCachesWithIgnoreCache() {
        this.ignoreManager.ignoreCache("cache1");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        List<String> names = this.find(jsonNode, "name");
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.find(jsonNode, "status");
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        Assert.assertTrue((boolean)status.contains("IGNORED"));
    }

    private List<String> find(Json array, String name) {
        return array.asJsonList().stream().map(j -> j.at(name).getValue().toString()).collect(Collectors.toList());
    }

    @Test
    public void testGetGlobalConfig() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        GlobalConfiguration globalConfiguration = embeddedCacheManager.withSubject(ADMIN_USER).getCacheManagerConfiguration();
        String globalConfigJSON = this.jsonWriter.toJSON((ConfigurationInfo)globalConfiguration);
        AssertJUnit.assertEquals((String)globalConfigJSON, (String)json);
    }

    @Test
    public void testGetGlobalConfigXML() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration("application/xml"));
        ResponseAssertion.assertThat(response).isOk();
        String xml = response.getBody();
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(xml);
        GlobalConfigurationBuilder globalConfigurationBuilder = builderHolder.getGlobalConfigurationBuilder();
        Assert.assertNotNull((Object)globalConfigurationBuilder.build());
    }

    @Test
    public void testInfo() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.info());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json cmInfo = Json.read((String)json);
        AssertJUnit.assertFalse((boolean)cmInfo.at("version").asString().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members").asList().size());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members_physical_addresses").asList().size());
        AssertJUnit.assertEquals((String)"LON-1", (String)cmInfo.at("local_site").asString());
    }

    @Test
    public void testStats() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json cmStats = Json.read((String)json);
        Assert.assertTrue((boolean)cmStats.at("statistics_enabled").asBoolean());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("number_of_entries").asInteger());
        ((EmbeddedCacheManager)this.cacheManagers.iterator().next()).getCache("cache1").put((Object)"key", (Object)"value");
        cmStats = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats())).getBody());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("number_of_entries").asInteger());
    }

    private Map<String, String> cacheAndConfig(Json list) {
        HashMap<String, String> result = new HashMap<String, String>();
        list.asJsonList().forEach(node -> result.put(node.at("name").asString(), node.at("configuration").toString()));
        return result;
    }

    private List<String> extractCacheNames(Json cacheStatuses) {
        return cacheStatuses.asJsonList().stream().map(j -> j.at("cache_name").asString()).collect(Collectors.toList());
    }
}

