/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.IndexedCacheNonIndexedEntityTest")
public class IndexedCacheNonIndexedEntityTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "IndexedCacheNonIndexedEntitiesTest";
    private static final String SCHEMA = "message NonIndexed { optional string name = 1; }";
    protected RestClient client;
    protected RestCacheClient cacheClient;
    private RestServerHelper restServer;

    protected EmbeddedCacheManager createCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        this.restServer = new RestServerHelper(cm);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName() + "-" + cm.getAddress());
        RestClientConfigurationBuilder clientConfigurationBuilder = new RestClientConfigurationBuilder();
        clientConfigurationBuilder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort());
        this.client = RestClient.forConfiguration((RestClientConfiguration)clientConfigurationBuilder.build());
        return cm;
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.client.close();
        this.restServer.stop();
    }

    @Test
    public void shouldPreventNonIndexedEntities() {
        CompletionStage response = this.client.schemas().post("customer", SCHEMA);
        ResponseAssertion.assertThat(response).isOk();
        ConfigurationBuilder configurationBuilder = this.getDefaultStandaloneCacheConfig(false);
        configurationBuilder.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("NonIndexed");
        String config = new JsonWriter().toJSON((ConfigurationInfo)configurationBuilder.build());
        RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)config);
        RestCacheClient cacheClient = this.client.cache(CACHE_NAME);
        response = cacheClient.createWithConfiguration(configEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isBadRequest();
        ResponseAssertion.assertThat(response).containsReturnedText("The configured indexed-entity type 'NonIndexed' must be indexed. Please annotate it with @Indexed");
    }
}

