/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import javax.security.auth.Subject;
import org.infinispan.rest.BaseHttpRequestHandler;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RestRequestHandler
extends BaseHttpRequestHandler {
    protected static final Log logger = (Log)LogFactory.getLog(RestRequestHandler.class, Log.class);
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;
    private final String context;
    private Subject subject;
    private String authorization;
    private final Authenticator authenticator;

    RestRequestHandler(RestServer restServer) {
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.authenticator = this.configuration.authentication().enabled() ? this.configuration.authentication().authenticator() : null;
        this.context = this.configuration.contextPath();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        LookupResult invocationLookup;
        NettyRestRequest restRequest;
        this.restAccessLoggingHandler.preLog(request);
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        if (!Method.contains(request.method().name())) {
            NettyRestResponse restResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.FORBIDDEN).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        try {
            restRequest = new NettyRestRequest(request);
            invocationLookup = this.restServer.getRestDispatcher().lookupInvocation(restRequest);
            Invocation invocation = invocationLookup.getInvocation();
            if (invocation != null && invocation.deprecated()) {
                logger.warnDeprecatedCall(restRequest.toString());
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error during REST dispatch", e);
            }
            NettyRestResponse restResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        if (this.authenticator == null || this.isAnon(invocationLookup)) {
            this.handleRestRequest(ctx, restRequest, invocationLookup);
            return;
        }
        if (this.subject != null) {
            String authz = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
            if (Objects.equals(authz, this.authorization)) {
                restRequest.setSubject(this.subject);
                this.handleRestRequest(ctx, restRequest, invocationLookup);
                return;
            }
            this.subject = null;
            this.authorization = null;
        }
        this.authenticator.challenge(restRequest, ctx).whenComplete((authResponse, authThrowable) -> {
            boolean authorized;
            boolean hasError = authThrowable != null;
            boolean bl = authorized = authResponse.getStatus() != HttpResponseStatus.UNAUTHORIZED.code();
            if (!hasError && authorized) {
                this.authorization = restRequest.getAuthorizationHeader();
                this.subject = restRequest.getSubject();
                this.handleRestRequest(ctx, restRequest, invocationLookup);
            } else {
                try {
                    if (hasError) {
                        this.handleError(ctx, request, (Throwable)authThrowable);
                    } else {
                        this.sendResponse(ctx, request, (NettyRestResponse)authResponse);
                    }
                }
                finally {
                    request.release();
                }
            }
        });
    }

    private boolean isAnon(LookupResult lookupResult) {
        if (lookupResult == null || lookupResult.getInvocation() == null) {
            return true;
        }
        return lookupResult.getInvocation().anonymous();
    }

    private void handleRestRequest(ChannelHandlerContext ctx, NettyRestRequest restRequest, LookupResult invocationLookup) {
        this.restServer.getRestDispatcher().dispatch(restRequest, invocationLookup).whenComplete((restResponse, throwable) -> {
            FullHttpRequest request = restRequest.getFullHttpRequest();
            try {
                if (throwable == null) {
                    NettyRestResponse nettyRestResponse = (NettyRestResponse)restResponse;
                    this.sendResponse(ctx, request, nettyRestResponse);
                } else {
                    this.handleError(ctx, request, (Throwable)throwable);
                }
            }
            finally {
                request.release();
            }
        });
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debug("Native IO Exception", e);
            ctx.close();
        } else {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

