/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.nio.file.Path;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.CorsConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.util.logging.LogFactory;

public class RestServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RestServerConfiguration, RestServerConfigurationBuilder>
implements Builder<RestServerConfiguration> {
    static final Log logger = (Log)LogFactory.getLog(RestServerConfigurationBuilder.class, Log.class);
    private final AuthenticationConfigurationBuilder authentication;
    private final CorsConfigurationBuilder cors;
    private Path staticResources;
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_NAME = "rest";

    public RestServerConfigurationBuilder() {
        super(8080, RestServerConfiguration.attributeDefinitionSet());
        this.authentication = new AuthenticationConfigurationBuilder(this);
        this.cors = new CorsConfigurationBuilder();
    }

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.attributes.attribute(RestServerConfiguration.EXTENDED_HEADERS).set((Object)extendedHeaders);
        return this;
    }

    public RestServerConfigurationBuilder contextPath(String contextPath) {
        this.attributes.attribute(RestServerConfiguration.CONTEXT_PATH).set((Object)contextPath);
        return this;
    }

    public RestServerConfigurationBuilder maxContentLength(int maxContentLength) {
        this.attributes.attribute(RestServerConfiguration.MAX_CONTENT_LENGTH).set((Object)maxContentLength);
        return this;
    }

    public RestServerConfigurationBuilder compressionLevel(int compressLevel) {
        this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).set((Object)compressLevel);
        return this;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    public RestServerConfigurationBuilder addAll(List<CorsConfig> corsConfig) {
        this.cors.add(corsConfig);
        return this;
    }

    public RestServerConfigurationBuilder staticResources(Path dir) {
        this.staticResources = dir;
        return this;
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public CorsConfigurationBuilder cors() {
        return this.cors;
    }

    public void validate() {
        super.validate();
        this.authentication.validate();
        int compressionLevel = (Integer)this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).get();
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw logger.illegalCompressionLevel(compressionLevel);
        }
    }

    public RestServerConfiguration create() {
        if (!this.attributes.attribute(ProtocolServerConfiguration.NAME).isModified()) {
            String socketBinding = this.socketBinding();
            this.name(DEFAULT_NAME + (socketBinding == null ? "" : "-" + socketBinding));
        }
        return new RestServerConfiguration(this.attributes.protect(), this.ssl.create(), this.staticResources, this.authentication.create(), this.cors.create(), this.encryption.create());
    }

    public Builder<?> read(RestServerConfiguration template) {
        super.read((ProtocolServerConfiguration)template);
        this.attributes.read(template.attributes());
        this.authentication.read(template.authentication());
        this.cors.read(template.cors());
        this.encryption.read(template.encryption());
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestServerConfigurationBuilder self() {
        return this;
    }

    public RestServerConfigurationBuilder defaultCacheName(String defaultCacheName) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder idleTimeout(int idleTimeout) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpKeepAlive(boolean tcpKeepAlive) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder recvBufSize(int recvBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder sendBufSize(int sendBufSize) {
        throw logger.unsupportedConfigurationOption();
    }
}

