/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public class RedirectResource
implements ResourceHandler {
    private final String path;
    private final String redirectPath;
    private final boolean anonymous;

    public RedirectResource(String path, String redirectPath, boolean anonymous) {
        this.path = path;
        this.redirectPath = redirectPath;
        this.anonymous = anonymous;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path(this.path).anonymous(this.anonymous).handleWith(this::redirect).create();
    }

    private CompletionStage<RestResponse> redirect(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        responseBuilder.status(HttpResponseStatus.TEMPORARY_REDIRECT).header("Location", this.redirectPath);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }
}

