/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.setup.JmxRegistrar;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class MetricsResource
implements ResourceHandler {
    private static final Log log = (Log)LogFactory.getLog(MetricsResource.class, Log.class);
    private static final String METRICS_PATH = "/metrics";
    private final MetricsRequestHandler requestHandler = new MetricsRequestHandler();
    private final boolean auth;

    public MetricsResource(boolean auth) {
        this.registerBaseMetrics();
        this.auth = auth;
    }

    private void registerBaseMetrics() {
        try {
            new JmxRegistrar().init();
        }
        catch (IOException | IllegalArgumentException e) {
            log.debug("Failed to initialize base and vendor metrics from platform's JMX MBeans", e);
        }
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.OPTIONS).path(METRICS_PATH).anonymous(!this.auth).handleWith(this::metrics).invocation().methods(Method.GET, Method.OPTIONS).path("/metrics/*").anonymous(!this.auth).handleWith(this::metrics).create();
    }

    private CompletionStage<RestResponse> metrics(RestRequest restRequest) {
        try {
            List<String> accept = restRequest.headers(HttpHeaderNames.ACCEPT.toString());
            if (restRequest.method() == Method.GET) {
                accept = accept.isEmpty() ? Collections.singletonList("text/plain") : accept.stream().map(h -> h.startsWith("application/openmetrics-text") ? "text/plain" : h).collect(Collectors.toList());
            } else if (restRequest.method() == Method.OPTIONS && accept.isEmpty()) {
                accept = Collections.singletonList("application/json");
            }
            NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
            this.requestHandler.handleRequest(restRequest.path(), restRequest.method().name(), accept.stream(), (status, message, headers) -> {
                ((NettyRestResponse.Builder)builder.status(status)).entity(message);
                for (String header : headers.keySet()) {
                    builder.header(header, headers.get(header));
                }
            });
            return CompletableFuture.completedFuture(builder.build());
        }
        catch (Exception e) {
            NettyRestResponse.Builder builder = new NettyRestResponse.Builder().status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
            return CompletableFuture.completedFuture(builder.build());
        }
    }
}

