/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.MutablePrincipalRoleMapper;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.server.core.ProtocolServer;

public class SecurityResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final String accessGrantedPath;
    private final String accessDeniedPath;
    private final MutablePrincipalRoleMapper principalRoleMapper;

    public SecurityResource(InvocationHelper invocationHelper, String accessGrantedPath, String accessDeniedPath) {
        this.invocationHelper = invocationHelper;
        this.accessGrantedPath = accessGrantedPath;
        this.accessDeniedPath = accessDeniedPath;
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(invocationHelper.getRestCacheManager().getInstance());
        PrincipalRoleMapper mapper = globalConfiguration.security().authorization().roleMapperConfiguration().roleMapper();
        this.principalRoleMapper = mapper != null && mapper instanceof MutablePrincipalRoleMapper ? (MutablePrincipalRoleMapper)mapper : null;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/login").withAction("config").anonymous().handleWith(this::loginConfiguration).invocation().methods(Method.GET, Method.POST).deprecated().path("/v2/login").withAction("login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).deprecated().path("/v2/login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).path("/v2/security/user/acl").handleWith(this::acl).invocation().method(Method.GET).path("/v2/security/roles").permission(AuthorizationPermission.ADMIN).name("ROLES").auditContext(AuditContext.SERVER).handleWith(this::listAllRoles).invocation().method(Method.GET).path("/v2/security/roles/{principal}").permission(AuthorizationPermission.ADMIN).name("ROLES PRINCIPAL").auditContext(AuditContext.SERVER).handleWith(this::listPrincipalRoles).invocation().methods(Method.PUT).path("/v2/security/roles/{principal}").withAction("grant").permission(AuthorizationPermission.ADMIN).name("ROLES GRANT").auditContext(AuditContext.SERVER).handleWith(this::grant).invocation().methods(Method.PUT).path("/v2/security/roles/{principal}").withAction("deny").permission(AuthorizationPermission.ADMIN).name("ROLES DENY").auditContext(AuditContext.SERVER).handleWith(this::deny).create();
    }

    private CompletionStage<RestResponse> deny(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.CONFLICT).build());
        }
        String principal = request.variables().get("principal");
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        roles.forEach(r -> this.principalRoleMapper.deny(r, principal));
        return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NO_CONTENT).build());
    }

    private CompletionStage<RestResponse> grant(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.CONFLICT).build());
        }
        String principal = request.variables().get("principal");
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        roles.forEach(r -> this.principalRoleMapper.grant(r, principal));
        return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NO_CONTENT).build());
    }

    private CompletionStage<RestResponse> listAllRoles(RestRequest request) {
        GlobalAuthorizationConfiguration authorization = this.invocationHelper.getRestCacheManager().getInstance().getCacheManagerConfiguration().security().authorization();
        if (!authorization.enabled()) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).build());
        }
        Json roles = Json.array();
        authorization.roles().entrySet().stream().filter(e -> ((Role)e.getValue()).isInheritable()).forEach(e -> roles.add(e.getKey()));
        return ResourceUtil.asJsonResponseFuture(roles);
    }

    private CompletionStage<RestResponse> listPrincipalRoles(RestRequest request) {
        String principal = request.variables().get("principal");
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.CONFLICT).build());
        }
        Json roles = Json.array();
        this.principalRoleMapper.list(principal).forEach(r -> roles.add(r));
        return ResourceUtil.asJsonResponseFuture(roles);
    }

    private CompletionStage<RestResponse> acl(RestRequest request) {
        Subject subject = request.getSubject();
        RestCacheManager<Object> rcm = this.invocationHelper.getRestCacheManager();
        Collection<String> cacheNames = rcm.getCacheNames();
        Json acl = Json.object();
        if (subject == null) {
            acl.set("subject", Json.array());
        } else {
            Json jsonSubjects = Json.array();
            subject.getPrincipals().forEach(principal -> jsonSubjects.add(Json.object().set("name", (Object)principal.getName()).set("type", (Object)principal.getClass().getSimpleName())));
            acl.set("subject", jsonSubjects);
            Authorizer authorizer = rcm.getAuthorizer();
            SubjectACL globalACL = authorizer.getACL(subject);
            acl.set("global", this.aclToJson(globalACL));
            Json caches = Json.object();
            acl.set("caches", caches);
            for (String cacheName : cacheNames) {
                Configuration cacheConfiguration = SecurityActions.getCacheConfigurationFromManager(rcm.getInstance(), cacheName);
                SubjectACL cacheACL = authorizer.getACL(subject, cacheConfiguration.security().authorization());
                caches.set(cacheName, this.aclToJson(cacheACL));
            }
        }
        return ResourceUtil.asJsonResponseFuture(acl);
    }

    private Json aclToJson(SubjectACL acl) {
        Json array = Json.array();
        for (AuthorizationPermission permission : acl.getPermissions()) {
            array.add((Object)permission.name());
        }
        return array;
    }

    private CompletionStage<RestResponse> loginConfiguration(RestRequest restRequest) {
        Map loginConfiguration = this.invocationHelper.getServer().getLoginConfiguration((ProtocolServer)this.invocationHelper.getProtocolServer());
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)loginConfiguration));
    }

    private CompletionStage<RestResponse> login(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        responseBuilder.status(HttpResponseStatus.TEMPORARY_REDIRECT).header("Location", this.accessGrantedPath);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }
}

