/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.PipelineInitializationTest")
public class PipelineInitializationTest
extends AbstractInfinispanTest {
    private RestServerHelper restServer;
    private RestClient client1;
    private RestClient client2;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder configurationBuilder = new RestClientConfigurationBuilder();
        configurationBuilder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort());
        this.client1 = RestClient.forConfiguration((RestClientConfiguration)configurationBuilder.build());
        this.client2 = RestClient.forConfiguration((RestClientConfiguration)configurationBuilder.build());
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws IOException {
        this.restServer.clear();
        if (this.restServer != null) {
            this.restServer.stop();
            this.client1.close();
            this.client2.close();
        }
    }

    private Supplier<Integer> createTask(RestClient client, CountDownLatch latch) {
        return () -> {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.caches());
            return response.getStatus();
        };
    }

    @Test
    public void testInitializationRules() throws InterruptedException, ExecutionException {
        int numTasks = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(numTasks);
        CountDownLatch startLatch = new CountDownLatch(1);
        ArrayList<Supplier<Integer>> suppliers = new ArrayList<Supplier<Integer>>();
        for (int i = 0; i < numTasks; ++i) {
            RestClient client = i % 2 == 0 ? this.client1 : this.client2;
            suppliers.add(this.createTask(client, startLatch));
        }
        List results = suppliers.stream().map(s -> CompletableFuture.supplyAsync(s, executorService)).collect(Collectors.toList());
        startLatch.countDown();
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(5L, TimeUnit.SECONDS));
        for (CompletableFuture result : results) {
            AssertJUnit.assertFalse((boolean)result.isCompletedExceptionally());
            Assert.assertEquals((int)((Integer)result.get()), (int)200);
        }
    }
}

